/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamCepstrumSource
extends BaseDataProcessor {
    @S4Boolean(defaultValue=true)
    public static final String PROP_BINARY = "binary";
    @S4Double(defaultValue=25.625)
    public static final String PROP_FRAME_SIZE_MS = "frameSizeInMs";
    @S4Double(defaultValue=10.0)
    public static final String PROP_FRAME_SHIFT_MS = "frameShiftInMs";
    @S4Integer(defaultValue=13)
    public static final String PROP_CEPSTRUM_LENGTH = "cepstrumLength";
    @S4Boolean(defaultValue=false)
    public static final String PROP_BIG_ENDIAN_DATA = "bigEndianData";
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLE_RATE = "sampleRate";
    private boolean binary;
    private ExtendedStreamTokenizer est;
    private DataInputStream binaryStream;
    private int numPoints;
    private int curPoint;
    private int cepstrumLength;
    private int frameShift;
    private int frameSize;
    private int sampleRate;
    private long firstSampleNumber;
    private boolean bigEndian;

    public StreamCepstrumSource(int n, boolean bl, float f, float f2, int n2) {
        this.initLogger();
        this.cepstrumLength = n;
        this.binary = bl;
        this.sampleRate = n2;
        this.frameShift = DataUtil.getSamplesPerWindow(n2, f);
        this.frameSize = DataUtil.getSamplesPerShift(n2, f2);
    }

    public StreamCepstrumSource() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.cepstrumLength = propertySheet.getInt(PROP_CEPSTRUM_LENGTH);
        this.binary = propertySheet.getBoolean(PROP_BINARY);
        this.bigEndian = propertySheet.getBoolean(PROP_BIG_ENDIAN_DATA);
        float f = propertySheet.getFloat(PROP_FRAME_SHIFT_MS);
        float f2 = propertySheet.getFloat(PROP_FRAME_SIZE_MS);
        this.sampleRate = propertySheet.getInt(PROP_SAMPLE_RATE);
        this.frameShift = DataUtil.getSamplesPerWindow(this.sampleRate, f);
        this.frameSize = DataUtil.getSamplesPerShift(this.sampleRate, f2);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.curPoint = -1;
        this.firstSampleNumber = 0L;
        this.bigEndian = false;
    }

    public void setInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.bigEndian = bl;
        if (this.binary) {
            this.binaryStream = new DataInputStream(new BufferedInputStream(inputStream));
            if (bl) {
                this.numPoints = this.binaryStream.readInt();
                System.out.println("BigEndian");
            } else {
                this.numPoints = Utilities.readLittleEndianInt(this.binaryStream);
                System.out.println("LittleEndian");
            }
            System.out.println("Frames: " + this.numPoints / this.cepstrumLength);
        } else {
            this.est = new ExtendedStreamTokenizer(inputStream, false);
            this.numPoints = this.est.getInt("num_frames");
            this.est.expectString("frames");
        }
        this.curPoint = -1;
        this.firstSampleNumber = 0L;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        if (this.curPoint == -1) {
            data = new DataStartSignal(this.sampleRate);
            ++this.curPoint;
        } else if (this.curPoint == this.numPoints) {
            if (this.numPoints > 0) {
                this.firstSampleNumber = this.firstSampleNumber - (long)this.frameShift + (long)this.frameSize - 1L;
            }
            int n = this.curPoint / this.cepstrumLength;
            int n2 = (n - 1) * this.frameShift + this.frameSize;
            long l = (long)((double)n2 / (double)this.sampleRate * 1000.0);
            data = new DataEndSignal(l);
            try {
                if (this.binary) {
                    this.binaryStream.close();
                } else {
                    this.est.close();
                }
                ++this.curPoint;
            }
            catch (IOException iOException) {
                throw new DataProcessingException("IOException closing cepstrum stream", iOException);
            }
        } else if (this.curPoint > this.numPoints) {
            data = null;
        } else {
            double[] dArray = new double[this.cepstrumLength];
            for (int i = 0; i < this.cepstrumLength; ++i) {
                try {
                    dArray[i] = this.binary ? (this.bigEndian ? (double)this.binaryStream.readFloat() : (double)Utilities.readLittleEndianFloat(this.binaryStream)) : (double)this.est.getFloat("cepstrum data");
                    ++this.curPoint;
                    continue;
                }
                catch (IOException iOException) {
                    throw new DataProcessingException("IOException reading from cepstrum stream", iOException);
                }
            }
            data = new DoubleData(dArray, this.sampleRate, this.firstSampleNumber);
            this.firstSampleNumber += (long)this.frameShift;
        }
        return data;
    }
}

