/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.TimeFrame;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.io.InputStream;

public class StreamDataSource
extends BaseDataProcessor {
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLE_RATE = "sampleRate";
    @S4Integer(defaultValue=3200)
    public static final String PROP_BYTES_PER_READ = "bytesPerRead";
    @S4Integer(defaultValue=16)
    public static final String PROP_BITS_PER_SAMPLE = "bitsPerSample";
    @S4Boolean(defaultValue=false)
    public static final String PROP_BIG_ENDIAN_DATA = "bigEndianData";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SIGNED_DATA = "signedData";
    private InputStream dataStream;
    protected int sampleRate;
    private int bytesPerRead;
    private int bytesPerValue;
    private long totalValuesRead;
    private boolean bigEndian;
    private boolean signedData;
    private boolean streamEndReached;
    private boolean utteranceEndSent;
    private boolean utteranceStarted;
    protected int bitsPerSample;
    private TimeFrame timeFrame = TimeFrame.INFINITE;

    public StreamDataSource(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.initLogger();
        this.init(n, n2, n3, bl, bl2);
    }

    public StreamDataSource() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.init(propertySheet.getInt(PROP_SAMPLE_RATE), propertySheet.getInt(PROP_BYTES_PER_READ), propertySheet.getInt(PROP_BITS_PER_SAMPLE), propertySheet.getBoolean(PROP_BIG_ENDIAN_DATA), propertySheet.getBoolean(PROP_SIGNED_DATA));
    }

    private void init(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.sampleRate = n;
        this.bytesPerRead = n2;
        this.bitsPerSample = n3;
        if (this.bitsPerSample % 8 != 0) {
            throw new IllegalArgumentException("bits per sample must be a multiple of 8");
        }
        this.bytesPerValue = n3 / 8;
        this.bigEndian = bl;
        this.signedData = bl2;
        this.bytesPerRead += n2 % 2;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void setInputStream(InputStream inputStream) {
        this.setInputStream(inputStream, TimeFrame.INFINITE);
    }

    public void setInputStream(InputStream inputStream, TimeFrame timeFrame) {
        this.dataStream = inputStream;
        this.timeFrame = timeFrame;
        this.streamEndReached = false;
        this.utteranceEndSent = false;
        this.utteranceStarted = false;
        this.totalValuesRead = 0L;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = null;
        if (this.streamEndReached) {
            if (!this.utteranceEndSent) {
                data = new DataEndSignal(this.getDuration());
                this.utteranceEndSent = true;
            }
        } else if (!this.utteranceStarted) {
            this.utteranceStarted = true;
            data = new DataStartSignal(this.sampleRate);
        } else if (this.dataStream != null) {
            while ((data = this.readNextFrame()) != null && this.getDuration() < this.timeFrame.getStart()) {
            }
            if (!(data != null && this.getDuration() <= this.timeFrame.getEnd() || this.utteranceEndSent)) {
                data = new DataEndSignal(this.getDuration());
                this.utteranceEndSent = true;
                this.streamEndReached = true;
            }
        } else {
            this.logger.warning("Input stream is not set");
            if (!this.utteranceEndSent) {
                data = new DataEndSignal(this.getDuration());
                this.utteranceEndSent = true;
            }
        }
        return data;
    }

    private DoubleData readNextFrame() throws DataProcessingException {
        Object[] objectArray;
        int n = 0;
        int n2 = this.bytesPerRead;
        byte[] byArray = new byte[this.bytesPerRead];
        long l = this.totalValuesRead;
        try {
            int n3;
            do {
                if ((n3 = this.dataStream.read(byArray, n, n2 - n)) <= 0) continue;
                n += n3;
            } while (n3 != -1 && n < n2);
            if (n <= 0) {
                this.closeDataStream();
                return null;
            }
            this.totalValuesRead += (long)(n / this.bytesPerValue);
            if (n < n2) {
                n = n % 2 == 0 ? n + 2 : n + 3;
                objectArray = new byte[n];
                System.arraycopy(byArray, 0, objectArray, 0, n);
                byArray = objectArray;
                this.closeDataStream();
            }
        }
        catch (IOException iOException) {
            throw new DataProcessingException("Error reading data", iOException);
        }
        objectArray = this.bigEndian ? (Object[])DataUtil.bytesToValues(byArray, 0, n, this.bytesPerValue, this.signedData) : (Object[])DataUtil.littleEndianBytesToValues(byArray, 0, n, this.bytesPerValue, this.signedData);
        return new DoubleData((double[])objectArray, this.sampleRate, l);
    }

    private void closeDataStream() throws IOException {
        this.streamEndReached = true;
        if (this.dataStream != null) {
            this.dataStream.close();
        }
    }

    private long getDuration() {
        return (long)((double)this.totalValuesRead / (double)this.sampleRate * 1000.0);
    }
}

