/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamHTKCepstrum
extends BaseDataProcessor {
    @S4Boolean(defaultValue=true)
    public static final String PROP_BINARY = "binary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_BIGENDIAN = "bigEndian";
    @S4Double(defaultValue=25.625)
    public static final String PROP_FRAME_SIZE_MS = "frameSizeInMs";
    @S4Double(defaultValue=10.0)
    public static final String PROP_FRAME_SHIFT_MS = "frameShiftInMs";
    @S4Integer(defaultValue=13)
    public static final String PROP_CEPSTRUM_LENGTH = "cepstrumLength";
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLE_RATE = "sampleRate";
    private DataInputStream binaryStream;
    private int numPoints;
    private int curPoint;
    private int cepstrumLength;
    private int frameShift;
    private int frameSize;
    private int sampleRate;
    private long firstSampleNumber;
    private boolean bigEndian;

    public StreamHTKCepstrum(float f, float f2, boolean bl, int n) {
        this.initLogger();
        this.bigEndian = bl;
        this.sampleRate = n;
        this.frameShift = DataUtil.getSamplesPerWindow(n, f);
        this.frameSize = DataUtil.getSamplesPerShift(n, f2);
    }

    public StreamHTKCepstrum() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        float f = propertySheet.getFloat(PROP_FRAME_SHIFT_MS);
        float f2 = propertySheet.getFloat(PROP_FRAME_SIZE_MS);
        this.bigEndian = propertySheet.getBoolean(PROP_BIGENDIAN);
        this.sampleRate = propertySheet.getInt(PROP_SAMPLE_RATE);
        this.frameShift = DataUtil.getSamplesPerWindow(this.sampleRate, f);
        this.frameSize = DataUtil.getSamplesPerShift(this.sampleRate, f2);
        this.logger = propertySheet.getLogger();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.curPoint = -1;
        this.firstSampleNumber = 0L;
    }

    public void setInputStream(InputStream inputStream) throws IOException {
        this.binaryStream = new DataInputStream(new BufferedInputStream(inputStream));
        if (this.bigEndian) {
            this.numPoints = this.binaryStream.readInt();
            int n = this.binaryStream.readInt();
            short s = this.binaryStream.readShort();
            short s2 = this.binaryStream.readShort();
            this.cepstrumLength = s / 4;
            this.numPoints *= this.cepstrumLength;
            this.logger.info("Sample period is " + n);
            this.logger.info("Sample size " + s);
            this.logger.info("Parameter kind " + s2);
            this.logger.info("BigEndian");
        } else {
            this.numPoints = Utilities.readLittleEndianInt(this.binaryStream);
            int n = Utilities.readLittleEndianInt(this.binaryStream);
            short s = StreamHTKCepstrum.readLittleEndianShort(this.binaryStream);
            short s3 = StreamHTKCepstrum.readLittleEndianShort(this.binaryStream);
            this.cepstrumLength = s / 4;
            this.numPoints *= this.cepstrumLength;
            this.logger.info("Sample period is " + n);
            this.logger.info("Sample size " + s);
            this.logger.info("Parameter kind " + s3);
            this.logger.info("LittleEndian");
        }
        System.out.println("Frames: " + this.numPoints / this.cepstrumLength);
        this.curPoint = -1;
        this.firstSampleNumber = 0L;
    }

    public static short readLittleEndianShort(DataInputStream dataInputStream) throws IOException {
        short s = 0;
        for (int i = 0; i < 16; i += 8) {
            int n = 0xFF & dataInputStream.readByte();
            s = (short)(s | n << i);
        }
        return s;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        if (this.curPoint == -1) {
            data = new DataStartSignal(this.sampleRate);
            ++this.curPoint;
        } else if (this.curPoint == this.numPoints) {
            if (this.numPoints > 0) {
                this.firstSampleNumber = this.firstSampleNumber - (long)this.frameShift + (long)this.frameSize - 1L;
            }
            int n = this.curPoint / this.cepstrumLength;
            int n2 = (n - 1) * this.frameShift + this.frameSize;
            long l = (long)((double)n2 / (double)this.sampleRate * 1000.0);
            data = new DataEndSignal(l);
            try {
                this.binaryStream.close();
                ++this.curPoint;
            }
            catch (IOException iOException) {
                throw new DataProcessingException("IOException closing cepstrum stream", iOException);
            }
        } else if (this.curPoint > this.numPoints) {
            data = null;
        } else {
            double[] dArray = new double[this.cepstrumLength];
            for (int i = 0; i < this.cepstrumLength; ++i) {
                try {
                    dArray[i] = this.bigEndian ? (double)this.binaryStream.readFloat() : (double)Utilities.readLittleEndianFloat(this.binaryStream);
                    ++this.curPoint;
                    continue;
                }
                catch (IOException iOException) {
                    throw new DataProcessingException("IOException reading from cepstrum stream", iOException);
                }
            }
            data = new DoubleData(dArray, this.sampleRate, this.firstSampleNumber);
            this.firstSampleNumber += (long)this.frameShift;
        }
        return data;
    }
}

