/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class Utterance {
    private final String name;
    private final ByteArrayOutputStream audioBuffer;
    private final AudioFormat audioFormat;

    public Utterance(String string, AudioFormat audioFormat) {
        this.name = string;
        this.audioFormat = audioFormat;
        this.audioBuffer = new ByteArrayOutputStream();
    }

    public String getName() {
        return this.name;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = this.audioBuffer;
        synchronized (byteArrayOutputStream) {
            this.audioBuffer.write(byArray, 0, byArray.length);
        }
    }

    public byte[] getAudio() {
        return this.audioBuffer.toByteArray();
    }

    public float getAudioTime() {
        return (float)this.audioBuffer.size() / (this.audioFormat.getSampleRate() * (float)this.audioFormat.getSampleSizeInBits() / 8.0f);
    }

    public void save(String string, AudioFileFormat.Type type) throws IOException {
        File file = new File(string);
        byte[] byArray = this.getAudio();
        AudioInputStream audioInputStream = new AudioInputStream(new ByteArrayInputStream(byArray), this.getAudioFormat(), byArray.length);
        AudioSystem.write(audioInputStream, type, file);
    }
}

