/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;

public class VUMeter {
    private double rms;
    private double average;
    private double peak;
    private static final double log10 = Math.log(10.0);
    private static final double maxDB = Math.max(0.0, 20.0 * Math.log(32767.0) / log10);
    private final int peakHoldTime = 1000;
    private long then = System.currentTimeMillis();
    private final float a2 = -1.9556f;
    private final float a3 = 0.9565f;
    private final float b1 = 0.978f;
    private final float b2 = -1.9561f;
    private final float b3 = 0.978f;

    public final synchronized double getRmsDB() {
        return Math.max(0.0, 20.0 * Math.log(this.rms) / log10);
    }

    public final synchronized double getAverageDB() {
        return Math.max(0.0, 20.0 * Math.log(this.average) / log10);
    }

    public final synchronized double getPeakDB() {
        return Math.max(0.0, 20.0 * Math.log(this.peak) / log10);
    }

    public final synchronized boolean getIsClipping() {
        return 32767.0 < 2.0 * this.peak;
    }

    public final synchronized double getMaxDB() {
        return maxDB;
    }

    public void calculateVULevels(Data data) {
        if (data instanceof DoubleData) {
            double[] dArray = ((DoubleData)data).getValues();
            this.calculateVULevels(dArray);
        }
    }

    public void calculateVULevels(byte[] byArray, int n, int n2) {
        short[] sArray = new short[n2 / 2];
        for (int i = 0; i < n2 / 2; ++i) {
            int n3 = n + 2 * i;
            sArray[i] = (short)(byArray[n3] << 8 | 0xFF & byArray[n3 + 1]);
        }
        this.calculateVULevels(sArray);
    }

    private synchronized void calculateVULevels(double[] dArray) {
        double d = 0.0;
        this.average = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d4 = dArray[i];
            double d5 = 0.0;
            double d6 = 0.0;
            if (i > 0) {
                d5 = dArray[i - 1];
            }
            if (i > 1) {
                d6 = dArray[i - 2];
            }
            double d7 = (double)0.978f * d4 + (double)-1.9561f * d5 + (double)0.978f * d6 - (double)-1.9556f * d2 - (double)0.9565f * d3;
            d3 = d2;
            d2 = d7;
            double d8 = Math.abs(d7);
            long l = System.currentTimeMillis();
            d += d8 * d8;
            this.average += d8;
            if (d8 > this.peak) {
                this.peak = d8;
                continue;
            }
            if (l - this.then <= 1000L) continue;
            this.peak = d8;
            this.then = l;
        }
        this.rms = d / (double)dArray.length;
        this.rms = Math.sqrt(this.rms);
        this.average /= (double)dArray.length;
    }

    private synchronized void calculateVULevels(short[] sArray) {
        double d = 0.0;
        this.average = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            double d4 = 0.0;
            double d5 = 0.0;
            if (i > 0) {
                d4 = sArray[i - 1];
            }
            if (i > 1) {
                d5 = sArray[i - 2];
            }
            double d6 = (double)(0.978f * (float)s) + (double)-1.9561f * d4 + (double)0.978f * d5 - (double)-1.9556f * d2 - (double)0.9565f * d3;
            d3 = d2;
            d2 = d6;
            double d7 = Math.abs(d6);
            long l = System.currentTimeMillis();
            d += d7 * d7;
            this.average += d7;
            if (d7 > this.peak) {
                this.peak = d7;
                continue;
            }
            if (l - this.then <= 1000L) continue;
            this.peak = d7;
            this.then = l;
        }
        this.rms = d / (double)sArray.length;
        this.rms = Math.sqrt(this.rms);
        this.average /= (double)sArray.length;
    }
}

