/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.FrontEndUtils;
import edu.cmu.sphinx.frontend.util.Microphone;
import edu.cmu.sphinx.frontend.util.VUMeter;
import edu.cmu.sphinx.frontend.util.VUMeterPanel;
import java.awt.BorderLayout;
import javax.swing.JDialog;

public class VUMeterMonitor
extends BaseDataProcessor {
    final VUMeter vumeter = new VUMeter();
    final VUMeterPanel vuMeterPanel = new VUMeterPanel();
    final JDialog vuMeterDialog;

    public VUMeterMonitor() {
        this.vuMeterPanel.setVu(this.vumeter);
        this.vuMeterPanel.start();
        this.vuMeterDialog = new JDialog();
        this.vuMeterDialog.setBounds(100, 100, 100, 400);
        this.vuMeterDialog.getContentPane().setLayout(new BorderLayout());
        this.vuMeterDialog.getContentPane().add(this.vuMeterPanel);
        this.vuMeterDialog.setVisible(true);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.getPredecessor().getData();
        if (data instanceof DataStartSignal) {
            this.vuMeterPanel.setVisible(FrontEndUtils.getFrontEndProcessor(this, Microphone.class) != null);
        }
        if (data instanceof DoubleData) {
            this.vumeter.calculateVULevels(data);
        }
        return data;
    }

    public JDialog getVuMeterDialog() {
        return this.vuMeterDialog;
    }

    public static void main(String[] stringArray) throws DataProcessingException {
        Microphone microphone = new Microphone(16000, 16, 1, true, true, true, 10, false, "selectChannel", 2, "default", 6400);
        microphone.initialize();
        microphone.startRecording();
        VUMeterMonitor vUMeterMonitor = new VUMeterMonitor();
        vUMeterMonitor.getVuMeterDialog().setModal(true);
        vUMeterMonitor.setPredecessor(microphone);
        while (true) {
            vUMeterMonitor.getData();
        }
    }
}

