/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.util.VUMeter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class VUMeterPanel
extends JPanel {
    VUMeter vu;
    boolean quit;
    Thread thread;
    final int numberOfLights = 50;
    final int greenLevel = 15;
    final int yellowLevel = 35;
    final int redLevel = 45;

    public void setVu(VUMeter vUMeter) {
        this.vu = vUMeter;
    }

    public void start() {
        this.quit = false;
        this.thread = new VUMeterPanelThread();
        this.thread.start();
    }

    public void stop() {
        this.quit = true;
        boolean bl = false;
        while (!bl) {
            try {
                this.thread.join();
                bl = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.vu != null) {
            this.paintVUMeter(graphics);
        }
    }

    public VUMeter getVu() {
        return this.vu;
    }

    private void paintVUMeter(Graphics graphics) {
        int n = (int)(this.vu.getRmsDB() / this.vu.getMaxDB() * 50.0);
        int n2 = (int)(this.vu.getPeakDB() / this.vu.getMaxDB() * 50.0);
        assert (n >= 0);
        assert (n < 50);
        Dimension dimension = this.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height / 50;
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
        for (int i = 0; i < n; ++i) {
            this.setLevelColor(i, graphics);
            graphics.fillRect(1, dimension.height - i * n4 + 1, n3 - 2, n4 - 2);
        }
        this.setLevelColor(n2, graphics);
        graphics.fillRect(1, dimension.height - n2 * n4 + 1, n3 - 2, n4 - 2);
    }

    private void setLevelColor(int n, Graphics graphics) {
        if (n < 15) {
            graphics.setColor(Color.BLUE);
        } else if (n < 35) {
            graphics.setColor(Color.GREEN);
        } else if (n < 45) {
            graphics.setColor(Color.YELLOW);
        } else {
            graphics.setColor(Color.RED);
        }
    }

    class VUMeterPanelThread
    extends Thread {
        VUMeterPanelThread() {
        }

        @Override
        public void run() {
            while (!VUMeterPanel.this.quit) {
                VUMeterPanel.this.repaint();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

