/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.machlearn.OVector;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WavWriter
extends BaseDataProcessor {
    @S4String(defaultValue="seg000000")
    public static final String PROP_OUT_FILE_NAME_PATTERN = "outFilePattern";
    @S4Boolean(defaultValue=false)
    public static final String PROP_IS_COMPLETE_PATH = "isCompletePath";
    @S4Integer(defaultValue=16)
    public static final String PROP_BITS_PER_SAMPLE = "bitsPerSample";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SIGNED_DATA = "signedData";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CAPTURE_UTTERANCES = "captureUtterances";
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private int sampleRate;
    private boolean isInSpeech;
    private boolean isSigned = true;
    private int bitsPerSample;
    private String outFileNamePattern;
    protected boolean captureUtts;
    private boolean isCompletePath;

    public WavWriter(String string, boolean bl, int n, boolean bl2, boolean bl3) {
        this.initLogger();
        this.outFileNamePattern = string;
        this.isCompletePath = bl;
        this.bitsPerSample = n;
        if (n % 8 != 0) {
            throw new Error("StreamDataSource: bits per sample must be a multiple of 8.");
        }
        this.isSigned = bl2;
        this.captureUtts = bl3;
        this.initialize();
    }

    public WavWriter() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.outFileNamePattern = propertySheet.getString(PROP_OUT_FILE_NAME_PATTERN);
        this.isCompletePath = propertySheet.getBoolean(PROP_IS_COMPLETE_PATH);
        this.bitsPerSample = propertySheet.getInt(PROP_BITS_PER_SAMPLE);
        if (this.bitsPerSample % 8 != 0) {
            throw new Error("StreamDataSource: bits per sample must be a multiple of 8.");
        }
        this.isSigned = propertySheet.getBoolean(PROP_SIGNED_DATA);
        this.captureUtts = propertySheet.getBoolean(PROP_CAPTURE_UTTERANCES);
        this.initialize();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Object object;
        Data data = this.getPredecessor().getData();
        if (data instanceof DataStartSignal) {
            this.sampleRate = ((DataStartSignal)data).getSampleRate();
        }
        if (data instanceof DataStartSignal || data instanceof SpeechStartSignal && this.captureUtts) {
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
        }
        if (data instanceof DataEndSignal && !this.captureUtts || data instanceof SpeechEndSignal && this.captureUtts) {
            object = this.isCompletePath ? this.outFileNamePattern : WavWriter.getNextFreeIndex(this.outFileNamePattern);
            this.writeFile((String)object);
            this.isInSpeech = false;
        }
        if (data instanceof SpeechStartSignal) {
            this.isInSpeech = true;
        }
        if ((data instanceof DoubleData || data instanceof FloatData) && (this.isInSpeech || !this.captureUtts)) {
            double[] dArray;
            object = data instanceof DoubleData ? (DoubleData)data : DataUtil.FloatData2DoubleData((FloatData)data);
            for (double d : dArray = ((OVector)object).getValues()) {
                try {
                    this.dos.writeShort(new Short((short)d).shortValue());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return data;
    }

    private static String getNextFreeIndex(String string) {
        String string2;
        int n = 0;
        while (true) {
            String string3 = Integer.toString(n);
            string2 = string.substring(0, Math.max(0, string.length() - string3.length())) + string3 + ".wav";
            if (!new File(string2).isFile()) break;
            ++n;
        }
        return string2;
    }

    @Override
    public void initialize() {
        super.initialize();
        assert (this.outFileNamePattern != null);
        this.baos = new ByteArrayOutputStream();
    }

    public void setOutFilePattern(String string) {
        this.outFileNamePattern = string;
    }

    private static AudioFileFormat.Type getTargetType(String string) {
        AudioFileFormat.Type[] typeArray;
        for (AudioFileFormat.Type type : typeArray = AudioSystem.getAudioFileTypes()) {
            if (!type.getExtension().equals(string)) continue;
            return type;
        }
        return null;
    }

    public static byte[] valuesToBytes(double[] dArray, int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        byte[] byArray = new byte[n * dArray.length];
        int n2 = 0;
        for (double d : dArray) {
            int n3 = (int)d;
            for (int i = n - 1; i >= 0; ++i) {
                byArray[n2 + i] = (byte)(n3 & 0xFF);
                n3 >>= 8;
            }
            n2 += n;
        }
        return byArray;
    }

    protected void writeFile(String string) {
        AudioFormat audioFormat = new AudioFormat(this.sampleRate, this.bitsPerSample, 1, this.isSigned, true);
        AudioFileFormat.Type type = WavWriter.getTargetType("wav");
        byte[] byArray = this.baos.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, byArray.length / audioFormat.getFrameSize());
        File file = new File(string);
        if (AudioSystem.isFileTypeSupported(type, audioInputStream)) {
            try {
                AudioSystem.write(audioInputStream, type, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

