/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.window;

import java.util.Arrays;

class DoubleBuffer {
    private final double[] buffer;
    private int occupancy;

    DoubleBuffer(int n) {
        this.buffer = new double[n];
        this.occupancy = 0;
    }

    public int getOccupancy() {
        return this.occupancy;
    }

    public double[] getBuffer() {
        return this.buffer;
    }

    public int appendAll(double[] dArray) {
        return this.append(dArray, 0, dArray.length);
    }

    public int append(double[] dArray, int n, int n2) {
        if (this.occupancy + n2 > this.buffer.length) {
            throw new Error("RaisedCosineWindower: overflow-buffer: attempting to fill buffer beyond its capacity.");
        }
        System.arraycopy(dArray, n, this.buffer, this.occupancy, n2);
        this.occupancy += n2;
        return this.occupancy;
    }

    public void padWindow(int n) {
        if (this.occupancy < n) {
            Arrays.fill(this.buffer, this.occupancy, n, 0.0);
        }
    }

    public void reset() {
        this.occupancy = 0;
    }
}

