/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.window;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.frontend.window.DoubleBuffer;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RaisedCosineWindower
extends BaseDataProcessor {
    @S4Double(defaultValue=25.625)
    public static final String PROP_WINDOW_SIZE_MS = "windowSizeInMs";
    private float windowSizeInMs;
    @S4Double(defaultValue=10.0)
    public static final String PROP_WINDOW_SHIFT_MS = "windowShiftInMs";
    private float windowShiftInMs;
    @S4Double(defaultValue=0.46)
    public static final String PROP_ALPHA = "alpha";
    private double alpha;
    public static final String WINDOW_SHIFT_SAMPLES = "windowSize";
    public static final String WINDOW_SIZE_SAMPLES = "windowShift";
    private double[] cosineWindow;
    private int windowShift;
    private List<Data> outputQueue;
    private DoubleBuffer overflowBuffer;
    private long currentFirstSampleNumber;
    private int sampleRate;

    public RaisedCosineWindower(double d, float f, float f2) {
        this.initLogger();
        this.alpha = d;
        this.windowSizeInMs = f;
        this.windowShiftInMs = f2;
    }

    public RaisedCosineWindower() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.alpha = propertySheet.getDouble(PROP_ALPHA);
        this.windowSizeInMs = propertySheet.getFloat(PROP_WINDOW_SIZE_MS);
        this.windowShiftInMs = propertySheet.getFloat(PROP_WINDOW_SHIFT_MS);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.outputQueue = new LinkedList<Data>();
    }

    private void createWindow(int n) {
        if (this.cosineWindow != null && n == this.sampleRate) {
            return;
        }
        this.sampleRate = n;
        int n2 = DataUtil.getSamplesPerWindow(n, this.windowSizeInMs);
        this.cosineWindow = new double[n2];
        this.windowShift = DataUtil.getSamplesPerShift(n, this.windowShiftInMs);
        if (this.cosineWindow.length > 1) {
            double d = 1.0 - this.alpha;
            for (int i = 0; i < this.cosineWindow.length; ++i) {
                this.cosineWindow[i] = d - this.alpha * Math.cos(Math.PI * 2 * (double)i / ((double)this.cosineWindow.length - 1.0));
            }
        }
        this.overflowBuffer = new DoubleBuffer(n2);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        if (this.outputQueue.isEmpty() && (data = this.getPredecessor().getData()) != null) {
            if (data instanceof DoubleData) {
                DoubleData doubleData = (DoubleData)data;
                if (this.currentFirstSampleNumber == -1L) {
                    this.currentFirstSampleNumber = doubleData.getFirstSampleNumber();
                }
                this.createWindow(doubleData.getSampleRate());
                this.process(doubleData);
            } else {
                if (data instanceof DataStartSignal) {
                    DataStartSignal dataStartSignal = (DataStartSignal)data;
                    this.createWindow(dataStartSignal.getSampleRate());
                    Map<String, Object> map = dataStartSignal.getProps();
                    map.put(WINDOW_SHIFT_SAMPLES, this.windowShift);
                    map.put(WINDOW_SIZE_SAMPLES, this.cosineWindow.length);
                    this.currentFirstSampleNumber = -1L;
                } else if (data instanceof SpeechStartSignal) {
                    this.currentFirstSampleNumber = -1L;
                } else if (data instanceof DataEndSignal || data instanceof SpeechEndSignal) {
                    this.processUtteranceEnd();
                }
                this.outputQueue.add(data);
            }
        }
        if (!this.outputQueue.isEmpty()) {
            data = this.outputQueue.remove(0);
            if (data instanceof DoubleData) assert (((DoubleData)data).getValues().length == this.cosineWindow.length);
            return data;
        }
        return null;
    }

    private void process(DoubleData doubleData) throws DataProcessingException {
        int n;
        Object object;
        double[] dArray = doubleData.getValues();
        int n2 = this.overflowBuffer.getOccupancy() + dArray.length;
        LinkedList<DoubleData> linkedList = new LinkedList<DoubleData>();
        linkedList.add(doubleData);
        Object object2 = null;
        while (n2 < this.cosineWindow.length) {
            object = this.getPredecessor().getData();
            if (object instanceof DoubleData) {
                linkedList.add((DoubleData)object);
                n2 += ((DoubleData)object).getValues().length;
                continue;
            }
            if (object instanceof DataEndSignal || object instanceof SpeechEndSignal) {
                object2 = object;
                break;
            }
            this.outputQueue.add((Data)object);
        }
        object = dArray;
        if (n2 != dArray.length) {
            object = new double[n2];
            System.arraycopy(this.overflowBuffer.getBuffer(), 0, object, 0, this.overflowBuffer.getOccupancy());
            n = this.overflowBuffer.getOccupancy();
            for (DoubleData doubleData2 : linkedList) {
                double[] dArray2 = doubleData2.getValues();
                System.arraycopy(dArray2, 0, object, n, dArray2.length);
                n += dArray2.length;
            }
        }
        n = this.applyRaisedCosineWindow((double[])object, n2);
        this.overflowBuffer.reset();
        if (n2 - n > 0) {
            this.overflowBuffer.append((double[])object, n, n2 - n);
        }
        if (object2 != null) {
            this.processUtteranceEnd();
            this.outputQueue.add((Data)object2);
        }
    }

    private void processUtteranceEnd() {
        if (this.overflowBuffer.getOccupancy() > 0) {
            this.overflowBuffer.padWindow(this.cosineWindow.length);
            this.applyRaisedCosineWindow(this.overflowBuffer.getBuffer(), this.cosineWindow.length);
            this.overflowBuffer.reset();
        }
    }

    private int applyRaisedCosineWindow(double[] dArray, int n) {
        int n2;
        Object object;
        if (n < this.cosineWindow.length) {
            object = new double[this.cosineWindow.length];
            System.arraycopy(dArray, 0, object, 0, n);
            dArray = object;
            n2 = 1;
        } else {
            n2 = RaisedCosineWindower.getWindowCount(n, this.cosineWindow.length, this.windowShift);
        }
        object = new double[n2][this.cosineWindow.length];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            double d = object[i];
            int n4 = n3;
            for (int j = 0; j < ((double)d).length; ++j) {
                d[j] = dArray[n4] * this.cosineWindow[j];
                ++n4;
            }
            this.outputQueue.add(new DoubleData((double[])d, this.sampleRate, this.currentFirstSampleNumber));
            this.currentFirstSampleNumber += (long)this.windowShift;
            n3 += this.windowShift;
        }
        return n3;
    }

    private static int getWindowCount(int n, int n2, int n3) {
        if (n < n2) {
            return 0;
        }
        int n4 = 1;
        int n5 = n2;
        while (n5 + n3 <= n) {
            ++n4;
            n5 += n3;
        }
        return n4;
    }

    public float getWindowShiftInMs() {
        if (this.windowShiftInMs == 0.0f) {
            throw new RuntimeException(this + " was not initialized yet!");
        }
        return this.windowShiftInMs;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public long roundToFrames(long l) {
        int n = DataUtil.getSamplesPerWindow(this.sampleRate, this.windowSizeInMs);
        int n2 = DataUtil.getSamplesPerShift(this.sampleRate, this.windowShiftInMs);
        long l2 = l / (long)n2;
        int n3 = (int)l2;
        long l3;
        while ((l3 = l - (long)(n2 * n3)) <= (long)n) {
            --n3;
        }
        return n2 * (n3 + 1) + n;
    }
}

