/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.State;

public class Arc {
    private float weight;
    private int iLabel;
    private int oLabel;
    private State nextState;

    public Arc() {
    }

    public Arc(int n, int n2, float f, State state) {
        this.weight = f;
        this.iLabel = n;
        this.oLabel = n2;
        this.nextState = state;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public int getIlabel() {
        return this.iLabel;
    }

    public void setIlabel(int n) {
        this.iLabel = n;
    }

    public int getOlabel() {
        return this.oLabel;
    }

    public void setOlabel(int n) {
        this.oLabel = n;
    }

    public State getNextState() {
        return this.nextState;
    }

    public void setNextState(State state) {
        this.nextState = state;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Arc arc = (Arc)object;
        if (this.iLabel != arc.iLabel) {
            return false;
        }
        if (this.nextState == null ? arc.nextState != null : this.nextState.getId() != arc.nextState.getId()) {
            return false;
        }
        if (this.oLabel != arc.oLabel) {
            return false;
        }
        return this.weight == arc.weight || Float.floatToIntBits(this.weight) == Float.floatToIntBits(arc.weight);
    }

    public int hashCode() {
        return 31 * (this.iLabel + 31 * (this.oLabel + (31 * (this.nextState == null ? 0 : this.nextState.getId()) + Float.floatToIntBits(this.weight))));
    }

    public String toString() {
        return "(" + this.iLabel + ", " + this.oLabel + ", " + this.weight + ", " + this.nextState + ")";
    }
}

