/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.utils.Utils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;

public class Convert {
    private Convert() {
    }

    public static void export(Fst fst, String string) throws IOException {
        Convert.exportSymbols(fst.getIsyms(), string + ".input.syms");
        Convert.exportSymbols(fst.getOsyms(), string + ".output.syms");
        Convert.exportFst(fst, string + ".fst.txt");
    }

    private static void exportFst(Fst fst, String string) throws IOException {
        String[] stringArray;
        FileWriter fileWriter = new FileWriter(string);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        State state = fst.getStart();
        printWriter.println(state.getId() + "\t" + state.getFinalWeight());
        int n = fst.getNumStates();
        for (int i = 0; i < n; ++i) {
            stringArray = fst.getState(i);
            if (stringArray.getId() == fst.getStart().getId()) continue;
            printWriter.println(stringArray.getId() + "\t" + stringArray.getFinalWeight());
        }
        String[] stringArray2 = fst.getIsyms();
        stringArray = fst.getOsyms();
        n = fst.getNumStates();
        for (int i = 0; i < n; ++i) {
            State state2 = fst.getState(i);
            int n2 = state2.getNumArcs();
            for (int j = 0; j < n2; ++j) {
                Arc arc = state2.getArc(j);
                String string2 = stringArray2 != null ? stringArray2[arc.getIlabel()] : Integer.toString(arc.getIlabel());
                String string3 = stringArray != null ? stringArray[arc.getOlabel()] : Integer.toString(arc.getOlabel());
                printWriter.println(state2.getId() + "\t" + arc.getNextState().getId() + "\t" + string2 + "\t" + string3 + "\t" + arc.getWeight());
            }
        }
        printWriter.close();
    }

    private static void exportSymbols(String[] stringArray, String string) throws IOException {
        if (stringArray == null) {
            return;
        }
        FileWriter fileWriter = new FileWriter(string);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            printWriter.println(string2 + "\t" + i);
        }
        printWriter.close();
    }

    private static HashMap<String, Integer> importSymbols(String string) throws NumberFormatException, IOException {
        String string2;
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\\t");
            String string3 = stringArray[0];
            Integer n = Integer.parseInt(stringArray[1]);
            hashMap.put(string3, n);
        }
        bufferedReader.close();
        return hashMap;
    }

    public static Fst importFst(String string, Semiring semiring) throws NumberFormatException, IOException {
        String string2;
        HashMap<String, Integer> hashMap;
        Fst fst = new Fst(semiring);
        HashMap<String, Integer> hashMap2 = Convert.importSymbols(string + ".input.syms");
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            hashMap2.put("<eps>", 0);
        }
        if ((hashMap = Convert.importSymbols(string + ".output.syms")) == null) {
            hashMap = new HashMap();
            hashMap.put("<eps>", 0);
        }
        HashMap<String, Integer> hashMap3 = Convert.importSymbols(string + ".states.syms");
        FileInputStream fileInputStream = new FileInputStream(string + ".fst.txt");
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "UTF-8"));
        boolean bl = true;
        HashMap<Integer, State> hashMap4 = new HashMap<Integer, State>();
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\\t");
            Integer n = hashMap3 == null ? Integer.valueOf(Integer.parseInt(stringArray[0])) : hashMap3.get(stringArray[0]);
            State state = (State)hashMap4.get(n);
            if (state == null) {
                state = new State(semiring.zero());
                fst.addState(state);
                hashMap4.put(n, state);
            }
            if (bl) {
                bl = false;
                fst.setStart(state);
            }
            if (stringArray.length > 2) {
                Integer n2 = hashMap3 == null ? Integer.valueOf(Integer.parseInt(stringArray[1])) : hashMap3.get(stringArray[1]);
                State state2 = (State)hashMap4.get(n2);
                if (state2 == null) {
                    state2 = new State(semiring.zero());
                    fst.addState(state2);
                    hashMap4.put(n2, state2);
                }
                if (hashMap2.get(stringArray[2]) == null) {
                    hashMap2.put(stringArray[2], hashMap2.size());
                }
                int n3 = hashMap2.get(stringArray[2]);
                if (hashMap.get(stringArray[3]) == null) {
                    hashMap.put(stringArray[3], hashMap.size());
                }
                int n4 = hashMap.get(stringArray[3]);
                float f = stringArray.length > 4 ? Float.parseFloat(stringArray[4]) : 0.0f;
                Arc arc = new Arc(n3, n4, f, state2);
                state.addArc(arc);
                continue;
            }
            if (stringArray.length > 1) {
                float f = Float.parseFloat(stringArray[1]);
                state.setFinalWeight(f);
                continue;
            }
            state.setFinalWeight(0.0f);
        }
        dataInputStream.close();
        fst.setIsyms(Utils.toStringArray(hashMap2));
        fst.setOsyms(Utils.toStringArray(hashMap));
        return fst;
    }
}

