/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;

public class Fst {
    private ArrayList<State> states = null;
    protected State start;
    protected String[] isyms;
    protected String[] osyms;
    protected Semiring semiring;

    public Fst() {
        this.states = new ArrayList();
    }

    public Fst(int n) {
        if (n > 0) {
            this.states = new ArrayList(n);
        }
    }

    public Fst(Semiring semiring) {
        this();
        this.semiring = semiring;
    }

    public State getStart() {
        return this.start;
    }

    public Semiring getSemiring() {
        return this.semiring;
    }

    public void setSemiring(Semiring semiring) {
        this.semiring = semiring;
    }

    public void setStart(State state) {
        this.start = state;
    }

    public int getNumStates() {
        return this.states.size();
    }

    public State getState(int n) {
        return this.states.get(n);
    }

    public void addState(State state) {
        this.states.add(state);
        state.id = this.states.size() - 1;
    }

    public String[] getIsyms() {
        return this.isyms;
    }

    public void setIsyms(String[] stringArray) {
        this.isyms = stringArray;
    }

    public String[] getOsyms() {
        return this.osyms;
    }

    public void setOsyms(String[] stringArray) {
        this.osyms = stringArray;
    }

    private void writeStringMap(ObjectOutputStream objectOutputStream, String[] stringArray) throws IOException {
        objectOutputStream.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            objectOutputStream.writeObject(stringArray[i]);
        }
    }

    private void writeFst(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        this.writeStringMap(objectOutputStream, this.isyms);
        this.writeStringMap(objectOutputStream, this.osyms);
        objectOutputStream.writeInt(this.states.indexOf(this.start));
        objectOutputStream.writeObject(this.semiring);
        objectOutputStream.writeInt(this.states.size());
        HashMap<State, Integer> hashMap = new HashMap<State, Integer>(this.states.size(), 1.0f);
        for (n = 0; n < this.states.size(); ++n) {
            State state = this.states.get(n);
            objectOutputStream.writeInt(state.getNumArcs());
            objectOutputStream.writeFloat(state.getFinalWeight());
            objectOutputStream.writeInt(state.getId());
            hashMap.put(state, n);
        }
        n = this.states.size();
        for (int i = 0; i < n; ++i) {
            State state = this.states.get(i);
            int n2 = state.getNumArcs();
            for (int j = 0; j < n2; ++j) {
                Arc arc = state.getArc(j);
                objectOutputStream.writeInt(arc.getIlabel());
                objectOutputStream.writeInt(arc.getOlabel());
                objectOutputStream.writeFloat(arc.getWeight());
                objectOutputStream.writeInt((Integer)hashMap.get(arc.getNextState()));
            }
        }
    }

    public void saveModel(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
        this.writeFst(objectOutputStream);
        objectOutputStream.flush();
        objectOutputStream.close();
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    protected static String[] readStringMap(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string;
            stringArray[i] = string = (String)objectInputStream.readObject();
        }
        return stringArray;
    }

    private static Fst readFst(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        String[] stringArray = Fst.readStringMap(objectInputStream);
        String[] stringArray2 = Fst.readStringMap(objectInputStream);
        int n2 = objectInputStream.readInt();
        Semiring semiring = (Semiring)objectInputStream.readObject();
        int n3 = objectInputStream.readInt();
        Fst fst = new Fst(n3);
        fst.isyms = stringArray;
        fst.osyms = stringArray2;
        fst.semiring = semiring;
        for (n = 0; n < n3; ++n) {
            int n4 = objectInputStream.readInt();
            State state = new State(n4 + 1);
            float f = objectInputStream.readFloat();
            if (f == fst.semiring.zero()) {
                f = fst.semiring.zero();
            } else if (f == fst.semiring.one()) {
                f = fst.semiring.one();
            }
            state.setFinalWeight(f);
            state.id = objectInputStream.readInt();
            fst.states.add(state);
        }
        fst.setStart(fst.states.get(n2));
        n3 = fst.getNumStates();
        for (n = 0; n < n3; ++n) {
            State state = fst.getState(n);
            for (int i = 0; i < state.initialNumArcs - 1; ++i) {
                Arc arc = new Arc();
                arc.setIlabel(objectInputStream.readInt());
                arc.setOlabel(objectInputStream.readInt());
                arc.setWeight(objectInputStream.readFloat());
                arc.setNextState(fst.states.get(objectInputStream.readInt()));
                state.addArc(arc);
            }
        }
        return fst;
    }

    public static Fst loadModel(String string) throws IOException, ClassNotFoundException {
        long l = Calendar.getInstance().getTimeInMillis();
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ObjectInputStream objectInputStream = null;
        fileInputStream = new FileInputStream(string);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        objectInputStream = new ObjectInputStream(bufferedInputStream);
        Fst fst = Fst.readFst(objectInputStream);
        objectInputStream.close();
        bufferedInputStream.close();
        fileInputStream.close();
        System.err.println("Load Time: " + (double)(Calendar.getInstance().getTimeInMillis() - l) / 1000.0);
        return fst;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Fst fst = (Fst)object;
        if (!Arrays.equals(this.isyms, fst.isyms)) {
            return false;
        }
        if (!Arrays.equals(this.osyms, fst.osyms)) {
            return false;
        }
        if (this.start == null ? fst.start != null : !this.start.equals(fst.start)) {
            return false;
        }
        if (this.states == null ? fst.states != null : !this.states.equals(fst.states)) {
            return false;
        }
        return !(this.semiring == null ? fst.semiring != null : !this.semiring.equals(fst.semiring));
    }

    public int hashCode() {
        return 31 * (Arrays.hashCode(this.isyms) + 31 * (Arrays.hashCode(this.osyms) + 31 * ((this.start == null ? 0 : this.start.hashCode()) + 31 * ((this.states == null ? 0 : this.states.hashCode()) + 31 * (this.semiring == null ? 0 : this.semiring.hashCode())))));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Fst(start=" + this.start + ", isyms=" + Arrays.toString(this.isyms) + ", osyms=" + Arrays.toString(this.osyms) + ", semiring=" + this.semiring + ")\n");
        int n = this.states.size();
        for (int i = 0; i < n; ++i) {
            State state = this.states.get(i);
            stringBuilder.append("  " + state + "\n");
            int n2 = state.getNumArcs();
            for (int j = 0; j < n2; ++j) {
                Arc arc = state.getArc(j);
                stringBuilder.append("    " + arc + "\n");
            }
        }
        return stringBuilder.toString();
    }

    public void deleteState(State state) {
        if (state == this.start) {
            System.err.println("Cannot delete start state.");
            return;
        }
        this.states.remove(state);
        for (State state2 : this.states) {
            ArrayList<Arc> arrayList = new ArrayList<Arc>();
            for (int i = 0; i < state2.getNumArcs(); ++i) {
                Arc arc = state2.getArc(i);
                if (arc.getNextState().equals(state)) continue;
                arrayList.add(arc);
            }
            state2.setArcs(arrayList);
        }
    }

    public void remapStateIds() {
        int n = this.states.size();
        for (int i = 0; i < n; ++i) {
            this.states.get((int)i).id = i;
        }
    }

    public void deleteStates(HashSet<State> hashSet) {
        if (hashSet.contains(this.start)) {
            System.err.println("Cannot delete start state.");
            return;
        }
        ArrayList<State> arrayList = new ArrayList<State>();
        for (State state : this.states) {
            if (hashSet.contains(state)) continue;
            arrayList.add(state);
            ArrayList<Arc> arrayList2 = new ArrayList<Arc>();
            for (int i = 0; i < state.getNumArcs(); ++i) {
                Arc arc = state.getArc(i);
                if (hashSet.contains(arc.getNextState())) continue;
                arrayList2.add(arc);
            }
            state.setArcs(arrayList2);
        }
        this.states = arrayList;
        this.remapStateIds();
    }
}

