/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.ImmutableState;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;

public class ImmutableFst
extends Fst {
    private ImmutableState[] states = null;
    private int numStates;

    private ImmutableFst() {
    }

    private ImmutableFst(int n) {
        super(0);
        this.numStates = n;
        this.states = new ImmutableState[n];
    }

    @Override
    public int getNumStates() {
        return this.numStates;
    }

    @Override
    public ImmutableState getState(int n) {
        return this.states[n];
    }

    @Override
    public void addState(State state) {
        throw new IllegalArgumentException("You cannot modify an ImmutableFst.");
    }

    @Override
    public void saveModel(String string) throws IOException {
        throw new IllegalArgumentException("You cannot serialize an ImmutableFst.");
    }

    private static ImmutableFst readImmutableFst(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String[] stringArray = ImmutableFst.readStringMap(objectInputStream);
        String[] stringArray2 = ImmutableFst.readStringMap(objectInputStream);
        int n = objectInputStream.readInt();
        Semiring semiring = (Semiring)objectInputStream.readObject();
        int n2 = objectInputStream.readInt();
        ImmutableFst immutableFst = new ImmutableFst(n2);
        immutableFst.isyms = stringArray;
        immutableFst.osyms = stringArray2;
        immutableFst.semiring = semiring;
        for (int i = 0; i < n2; ++i) {
            int n3 = objectInputStream.readInt();
            ImmutableState immutableState = new ImmutableState(n3 + 1);
            float f = objectInputStream.readFloat();
            if (f == immutableFst.semiring.zero()) {
                f = immutableFst.semiring.zero();
            } else if (f == immutableFst.semiring.one()) {
                f = immutableFst.semiring.one();
            }
            immutableState.setFinalWeight(f);
            immutableState.id = objectInputStream.readInt();
            immutableFst.states[immutableState.getId()] = immutableState;
        }
        immutableFst.setStart(immutableFst.states[n]);
        for (ImmutableState immutableState : immutableFst.states) {
            for (int i = 0; i < immutableState.initialNumArcs - 1; ++i) {
                Arc arc = new Arc();
                arc.setIlabel(objectInputStream.readInt());
                arc.setOlabel(objectInputStream.readInt());
                arc.setWeight(objectInputStream.readFloat());
                arc.setNextState(immutableFst.states[objectInputStream.readInt()]);
                immutableState.setArc(i, arc);
            }
        }
        return immutableFst;
    }

    public static ImmutableFst loadModel(InputStream inputStream) throws IOException, ClassNotFoundException {
        BufferedInputStream bufferedInputStream = null;
        ObjectInputStream objectInputStream = null;
        bufferedInputStream = new BufferedInputStream(inputStream);
        objectInputStream = new ObjectInputStream(bufferedInputStream);
        ImmutableFst immutableFst = ImmutableFst.readImmutableFst(objectInputStream);
        objectInputStream.close();
        bufferedInputStream.close();
        inputStream.close();
        return immutableFst;
    }

    public static ImmutableFst loadModel(String string) {
        ImmutableFst immutableFst;
        try {
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            ObjectInputStream objectInputStream = null;
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            objectInputStream = new ObjectInputStream(bufferedInputStream);
            immutableFst = ImmutableFst.readImmutableFst(objectInputStream);
            objectInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
        return immutableFst;
    }

    @Override
    public void deleteState(State state) {
        throw new IllegalArgumentException("You cannot modify an ImmutableFst.");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Fst(start=" + this.start + ", isyms=" + Arrays.toString(this.isyms) + ", osyms=" + Arrays.toString(this.osyms) + ", semiring=" + this.semiring + ")\n");
        for (ImmutableState immutableState : this.states) {
            stringBuilder.append("  " + immutableState + "\n");
            int n = ((State)immutableState).getNumArcs();
            for (int i = 0; i < n; ++i) {
                Arc arc = ((State)immutableState).getArc(i);
                stringBuilder.append("    " + arc + "\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImmutableFst immutableFst = (ImmutableFst)object;
        if (!Arrays.equals(this.states, immutableFst.states)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.states) + super.hashCode();
    }
}

