/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.State;
import java.util.Arrays;
import java.util.Comparator;

public class ImmutableState
extends State {
    private Arc[] arcs = null;

    protected ImmutableState() {
    }

    protected ImmutableState(int n) {
        super(0);
        this.initialNumArcs = n;
        this.arcs = new Arc[n];
    }

    @Override
    public void arcSort(Comparator<Arc> comparator) {
        Arrays.sort(this.arcs, comparator);
    }

    @Override
    public void addArc(Arc arc) {
        throw new IllegalArgumentException("You cannot modify an ImmutableState.");
    }

    @Override
    public void setArc(int n, Arc arc) {
        this.arcs[n] = arc;
    }

    @Override
    public Arc deleteArc(int n) {
        throw new IllegalArgumentException("You cannot modify an ImmutableState.");
    }

    public void setArcs(Arc[] arcArray) {
        this.arcs = arcArray;
    }

    @Override
    public int getNumArcs() {
        return this.initialNumArcs;
    }

    @Override
    public Arc getArc(int n) {
        return this.arcs[n];
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + this.id;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImmutableState immutableState = (ImmutableState)object;
        if (!Arrays.equals(this.arcs, immutableState.arcs)) {
            return false;
        }
        return super.equals(object);
    }
}

