/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst;

import edu.cmu.sphinx.fst.Arc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class State {
    protected int id = -1;
    private float fnlWeight;
    private ArrayList<Arc> arcs = null;
    protected int initialNumArcs = -1;

    protected State() {
        this.arcs = new ArrayList();
    }

    public State(float f) {
        this();
        this.fnlWeight = f;
    }

    public State(int n) {
        this.initialNumArcs = n;
        if (n > 0) {
            this.arcs = new ArrayList(n);
        }
    }

    public void arcSort(Comparator<Arc> comparator) {
        Collections.sort(this.arcs, comparator);
    }

    public float getFinalWeight() {
        return this.fnlWeight;
    }

    public void setArcs(ArrayList<Arc> arrayList) {
        this.arcs = arrayList;
    }

    public void setFinalWeight(float f) {
        this.fnlWeight = f;
    }

    public int getId() {
        return this.id;
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public void addArc(Arc arc) {
        this.arcs.add(arc);
    }

    public Arc getArc(int n) {
        return this.arcs.get(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        State state = (State)object;
        if (this.id != state.id) {
            return false;
        }
        if (this.fnlWeight != state.fnlWeight && Float.floatToIntBits(this.fnlWeight) != Float.floatToIntBits(state.fnlWeight)) {
            return false;
        }
        return !(this.arcs == null ? state.arcs != null : !this.arcs.equals(state.arcs));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(" + this.id + ", " + this.fnlWeight + ")");
        return stringBuilder.toString();
    }

    public Arc deleteArc(int n) {
        return this.arcs.remove(n);
    }

    public int hashCode() {
        return this.id * 991;
    }

    public void setArc(int n, Arc arc) {
        this.arcs.set(n, arc);
    }
}

