/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.ImmutableFst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.utils.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class Compose {
    private Compose() {
    }

    public static Fst compose(Fst fst, Fst fst2, Semiring semiring, boolean bl) {
        if (!Arrays.equals(fst.getOsyms(), fst2.getIsyms())) {
            return null;
        }
        Fst fst3 = new Fst(semiring);
        HashMap<Pair<State, State>, State> hashMap = new HashMap<Pair<State, State>, State>();
        LinkedList<Pair<State, State>> linkedList = new LinkedList<Pair<State, State>>();
        State state = fst.getStart();
        State state2 = fst2.getStart();
        if (state == null || state2 == null) {
            System.err.println("Cannot find initial state.");
            return null;
        }
        Pair pair = new Pair(state, state2);
        State state3 = new State(semiring.times(state.getFinalWeight(), state2.getFinalWeight()));
        fst3.addState(state3);
        fst3.setStart(state3);
        hashMap.put(pair, state3);
        linkedList.add(pair);
        while (!linkedList.isEmpty()) {
            pair = (Pair)linkedList.remove();
            state = (State)pair.getLeft();
            state2 = (State)pair.getRight();
            state3 = (State)hashMap.get(pair);
            int n = state.getNumArcs();
            int n2 = state2.getNumArcs();
            block1: for (int i = 0; i < n; ++i) {
                Arc arc = state.getArc(i);
                for (int j = 0; j < n2; ++j) {
                    State state4;
                    Arc arc2 = state2.getArc(j);
                    if (bl && arc.getOlabel() < arc2.getIlabel()) continue block1;
                    if (arc.getOlabel() != arc2.getIlabel()) continue;
                    State state5 = arc.getNextState();
                    Pair<State, State> pair2 = new Pair<State, State>(state5, state4 = arc2.getNextState());
                    State state6 = (State)hashMap.get(pair2);
                    if (state6 == null) {
                        state6 = new State(semiring.times(state5.getFinalWeight(), state4.getFinalWeight()));
                        fst3.addState(state6);
                        hashMap.put(pair2, state6);
                        linkedList.add(pair2);
                    }
                    Arc arc3 = new Arc(arc.getIlabel(), arc2.getOlabel(), semiring.times(arc.getWeight(), arc2.getWeight()), state6);
                    state3.addArc(arc3);
                }
            }
        }
        fst3.setIsyms(fst.getIsyms());
        fst3.setOsyms(fst2.getOsyms());
        return fst3;
    }

    public static Fst get(Fst fst, Fst fst2, Semiring semiring) {
        if (fst == null || fst2 == null) {
            return null;
        }
        if (!Arrays.equals(fst.getOsyms(), fst2.getIsyms())) {
            return null;
        }
        Fst fst3 = Compose.getFilter(fst.getOsyms(), semiring);
        Compose.augment(1, fst, semiring);
        Compose.augment(0, fst2, semiring);
        Fst fst4 = Compose.compose(fst, fst3, semiring, false);
        Fst fst5 = Compose.compose(fst4, fst2, semiring, false);
        return fst5;
    }

    public static Fst getFilter(String[] stringArray, Semiring semiring) {
        int n;
        Fst fst = new Fst(semiring);
        int n2 = stringArray.length;
        int n3 = stringArray.length + 1;
        fst.setIsyms(stringArray);
        fst.setOsyms(stringArray);
        State state = new State(stringArray.length + 3);
        state.setFinalWeight(semiring.one());
        State state2 = new State(stringArray.length);
        state2.setFinalWeight(semiring.one());
        State state3 = new State(stringArray.length);
        state3.setFinalWeight(semiring.one());
        fst.addState(state);
        state.addArc(new Arc(n3, n2, semiring.one(), state));
        state.addArc(new Arc(n2, n2, semiring.one(), state2));
        state.addArc(new Arc(n3, n3, semiring.one(), state3));
        for (n = 1; n < stringArray.length; ++n) {
            state.addArc(new Arc(n, n, semiring.one(), state));
        }
        fst.setStart(state);
        fst.addState(state2);
        state2.addArc(new Arc(n2, n2, semiring.one(), state2));
        for (n = 1; n < stringArray.length; ++n) {
            state2.addArc(new Arc(n, n, semiring.one(), state));
        }
        fst.addState(state3);
        state3.addArc(new Arc(n3, n3, semiring.one(), state3));
        for (n = 1; n < stringArray.length; ++n) {
            state3.addArc(new Arc(n, n, semiring.one(), state));
        }
        return fst;
    }

    public static void augment(int n, Fst fst, Semiring semiring) {
        String[] stringArray = fst.getIsyms();
        String[] stringArray2 = fst.getOsyms();
        int n2 = stringArray.length;
        int n3 = stringArray.length + 1;
        int n4 = stringArray2.length;
        int n5 = stringArray2.length + 1;
        int n6 = fst.getNumStates();
        for (int i = 0; i < n6; ++i) {
            State state = fst.getState(i);
            int n7 = fst instanceof ImmutableFst ? state.getNumArcs() - 1 : state.getNumArcs();
            for (int j = 0; j < n7; ++j) {
                Arc arc = state.getArc(j);
                if (n == 1 && arc.getOlabel() == 0) {
                    arc.setOlabel(n5);
                    continue;
                }
                if (n != 0 || arc.getIlabel() != 0) continue;
                arc.setIlabel(n2);
            }
            if (n == 0) {
                if (fst instanceof ImmutableFst) {
                    state.setArc(n7, new Arc(n3, 0, semiring.one(), state));
                    continue;
                }
                state.addArc(new Arc(n3, 0, semiring.one(), state));
                continue;
            }
            if (n != 1) continue;
            if (fst instanceof ImmutableFst) {
                state.setArc(n7, new Arc(0, n4, semiring.one(), state));
                continue;
            }
            state.addArc(new Arc(0, n4, semiring.one(), state));
        }
    }
}

