/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class Determinize {
    private Determinize() {
    }

    private static Pair<State, Float> getPair(ArrayList<Pair<State, Float>> arrayList, State state, Float f) {
        Pair<State, Float> pair = null;
        for (Pair<State, Float> pair2 : arrayList) {
            if (state.getId() != pair2.getLeft().getId()) continue;
            pair = pair2;
            break;
        }
        if (pair == null) {
            pair = new Pair<State, Float>(state, f);
            arrayList.add(pair);
        }
        return pair;
    }

    private static ArrayList<Integer> getUniqueLabels(Fst fst, ArrayList<Pair<State, Float>> arrayList) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Pair<State, Float> pair : arrayList) {
            State state = pair.getLeft();
            int n = state.getNumArcs();
            for (int i = 0; i < n; ++i) {
                Arc arc = state.getArc(i);
                if (arrayList2.contains(arc.getIlabel())) continue;
                arrayList2.add(arc.getIlabel());
            }
        }
        return arrayList2;
    }

    private static State getStateLabel(ArrayList<Pair<State, Float>> arrayList, HashMap<String, State> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Pair<State, Float> pair : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("(" + pair.getLeft() + "," + pair.getRight() + ")");
        }
        return hashMap.get(stringBuilder.toString());
    }

    public static Fst get(Fst fst) {
        if (fst.getSemiring() == null) {
            return null;
        }
        Semiring semiring = fst.getSemiring();
        Fst fst2 = new Fst(semiring);
        fst2.setIsyms(fst.getIsyms());
        fst2.setOsyms(fst.getOsyms());
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<String, State> hashMap = new HashMap<String, State>();
        State state = new State(semiring.zero());
        String string = "(" + fst.getStart() + "," + semiring.one() + ")";
        linkedList.add(new ArrayList());
        ((ArrayList)linkedList.peek()).add(new Pair<State, Float>(fst.getStart(), Float.valueOf(semiring.one())));
        fst2.addState(state);
        hashMap.put(string, state);
        fst2.setStart(state);
        while (!linkedList.isEmpty()) {
            ArrayList arrayList = (ArrayList)linkedList.remove();
            State state2 = Determinize.getStateLabel(arrayList, hashMap);
            ArrayList<Integer> arrayList2 = Determinize.getUniqueLabels(fst, arrayList);
            for (int n : arrayList2) {
                Object object;
                Object object22;
                Object object32;
                Float f = Float.valueOf(semiring.zero());
                for (Object object32 : arrayList) {
                    object22 = (State)((Pair)object32).getLeft();
                    object = (Float)((Pair)object32).getRight();
                    int n2 = ((State)object22).getNumArcs();
                    for (int i = 0; i < n2; ++i) {
                        Arc arc = ((State)object22).getArc(i);
                        if (n != arc.getIlabel()) continue;
                        f = Float.valueOf(semiring.plus(f.floatValue(), semiring.times(((Float)object).floatValue(), arc.getWeight())));
                    }
                }
                ArrayList arrayList3 = new ArrayList();
                for (Object object22 : arrayList) {
                    object = (State)((Pair)object22).getLeft();
                    Float f2 = (Float)((Pair)object22).getRight();
                    Float f3 = Float.valueOf(semiring.divide(semiring.one(), f.floatValue()));
                    int n3 = ((State)object).getNumArcs();
                    for (int i = 0; i < n3; ++i) {
                        Arc arc = ((State)object).getArc(i);
                        if (n != arc.getIlabel()) continue;
                        State state3 = arc.getNextState();
                        Pair<State, Float> pair = Determinize.getPair(arrayList3, state3, Float.valueOf(semiring.zero()));
                        pair.setRight(Float.valueOf(semiring.plus(pair.getRight().floatValue(), semiring.times(f3.floatValue(), semiring.times(f2.floatValue(), arc.getWeight())))));
                    }
                }
                object32 = "";
                object22 = arrayList3.iterator();
                while (object22.hasNext()) {
                    object = (Pair)object22.next();
                    State state4 = (State)((Pair)object).getLeft();
                    Float f4 = (Float)((Pair)object).getRight();
                    if (!((String)object32).equals("")) {
                        object32 = (String)object32 + ",";
                    }
                    object32 = (String)object32 + "(" + state4 + "," + f4 + ")";
                }
                if (hashMap.get(object32) == null) {
                    object22 = new State(semiring.zero());
                    fst2.addState((State)object22);
                    hashMap.put((String)object32, (State)object22);
                    object = Float.valueOf(((State)object22).getFinalWeight());
                    Iterator iterator = arrayList3.iterator();
                    while (iterator.hasNext()) {
                        Pair pair = (Pair)iterator.next();
                        object = Float.valueOf(semiring.plus(((Float)object).floatValue(), semiring.times(((State)pair.getLeft()).getFinalWeight(), ((Float)pair.getRight()).floatValue())));
                    }
                    ((State)object22).setFinalWeight(((Float)object).floatValue());
                    linkedList.add(arrayList3);
                }
                state2.addArc(new Arc(n, n, f.floatValue(), hashMap.get(object32)));
            }
        }
        return fst2;
    }
}

