/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.util.ArrayList;

public class ExtendFinal {
    private ExtendFinal() {
    }

    public static void apply(Fst fst) {
        Semiring semiring = fst.getSemiring();
        ArrayList<State> arrayList = new ArrayList<State>();
        int n = fst.getNumStates();
        for (int i = 0; i < n; ++i) {
            State state = fst.getState(i);
            if (state.getFinalWeight() == semiring.zero()) continue;
            arrayList.add(state);
        }
        State state = new State(semiring.one());
        fst.addState(state);
        for (State state2 : arrayList) {
            state2.addArc(new Arc(0, 0, state2.getFinalWeight(), state));
            state2.setFinalWeight(semiring.zero());
        }
    }

    public static void undo(Fst fst) {
        State state;
        int n;
        State state2 = null;
        int n2 = fst.getNumStates();
        for (n = 0; n < n2; ++n) {
            state = fst.getState(n);
            if (state.getFinalWeight() == fst.getSemiring().zero()) continue;
            state2 = state;
            break;
        }
        if (state2 == null) {
            System.err.println("Final state not found.");
            return;
        }
        for (n = 0; n < n2; ++n) {
            state = fst.getState(n);
            for (int i = 0; i < state.getNumArcs(); ++i) {
                Arc arc = state.getArc(i);
                if (arc.getIlabel() != 0 || arc.getOlabel() != 0 || arc.getNextState().getId() != state2.getId()) continue;
                state.setFinalWeight(arc.getWeight());
            }
        }
        fst.deleteState(state2);
    }
}

