/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.operations.Determinize;
import edu.cmu.sphinx.fst.operations.ExtendFinal;
import edu.cmu.sphinx.fst.operations.Reverse;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.utils.Pair;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.PriorityQueue;

public class NShortestPaths {
    private NShortestPaths() {
    }

    public static float[] shortestDistance(Fst fst) {
        Fst fst2 = Reverse.get(fst);
        float[] fArray = new float[fst2.getNumStates()];
        float[] fArray2 = new float[fst2.getNumStates()];
        Semiring semiring = fst2.getSemiring();
        Arrays.fill(fArray, semiring.zero());
        Arrays.fill(fArray2, semiring.zero());
        LinkedHashSet<State> linkedHashSet = new LinkedHashSet<State>();
        linkedHashSet.add(fst2.getStart());
        fArray[fst2.getStart().getId()] = semiring.one();
        fArray2[fst2.getStart().getId()] = semiring.one();
        while (!linkedHashSet.isEmpty()) {
            State state = (State)linkedHashSet.iterator().next();
            linkedHashSet.remove(state);
            float f = fArray2[state.getId()];
            fArray2[state.getId()] = semiring.zero();
            for (int i = 0; i < state.getNumArcs(); ++i) {
                float f2;
                Arc arc = state.getArc(i);
                State state2 = arc.getNextState();
                float f3 = fArray[arc.getNextState().getId()];
                if (f3 == (f2 = semiring.plus(f3, semiring.times(f, arc.getWeight())))) continue;
                fArray[arc.getNextState().getId()] = f2;
                fArray2[arc.getNextState().getId()] = semiring.plus(fArray2[arc.getNextState().getId()], semiring.times(f, arc.getWeight()));
                if (linkedHashSet.contains(state2)) continue;
                linkedHashSet.add(state2);
            }
        }
        return fArray;
    }

    public static Fst get(Fst fst, int n, boolean bl) {
        if (fst == null) {
            return null;
        }
        if (fst.getSemiring() == null) {
            return null;
        }
        Fst fst2 = fst;
        if (bl) {
            fst2 = Determinize.get(fst);
        }
        final Semiring semiring = fst2.getSemiring();
        Fst fst3 = new Fst(semiring);
        fst3.setIsyms(fst2.getIsyms());
        fst3.setOsyms(fst2.getOsyms());
        final float[] fArray = NShortestPaths.shortestDistance(fst2);
        ExtendFinal.apply(fst2);
        int[] nArray = new int[fst2.getNumStates()];
        PriorityQueue<Pair<State, Float>> priorityQueue = new PriorityQueue<Pair<State, Float>>(10, new Comparator<Pair<State, Float>>(){

            @Override
            public int compare(Pair<State, Float> pair, Pair<State, Float> pair2) {
                float f;
                float f2;
                float f3 = pair.getRight().floatValue();
                float f4 = fArray[pair.getLeft().getId()];
                float f5 = pair2.getRight().floatValue();
                float f6 = semiring.times(f5, f2 = fArray[pair2.getLeft().getId()]);
                if (semiring.naturalLess(f6, f = semiring.times(f3, f4))) {
                    return 1;
                }
                if (f6 == f) {
                    return 0;
                }
                return -1;
            }
        });
        HashMap<Pair<State, Float>, Pair> hashMap = new HashMap<Pair<State, Float>, Pair>(fst.getNumStates());
        HashMap<Pair, State> hashMap2 = new HashMap<Pair, State>(fst.getNumStates());
        State state = fst2.getStart();
        Pair<State, Float> pair = new Pair<State, Float>(state, Float.valueOf(semiring.one()));
        priorityQueue.add(pair);
        hashMap.put(pair, null);
        while (!priorityQueue.isEmpty()) {
            Object object;
            Pair pair2 = (Pair)priorityQueue.remove();
            State state2 = (State)pair2.getLeft();
            Float f = (Float)pair2.getRight();
            State state3 = new State(state2.getFinalWeight());
            fst3.addState(state3);
            hashMap2.put(pair2, state3);
            if (hashMap.get(pair2) == null) {
                fst3.setStart(state3);
            } else {
                object = (State)hashMap2.get(hashMap.get(pair2));
                State state4 = (State)((Pair)hashMap.get(pair2)).getLeft();
                for (int i = 0; i < state4.getNumArcs(); ++i) {
                    Arc arc = state4.getArc(i);
                    if (!arc.getNextState().equals(state2)) continue;
                    ((State)object).addArc(new Arc(arc.getIlabel(), arc.getOlabel(), arc.getWeight(), state3));
                }
            }
            object = state2.getId();
            int n2 = (Integer)object;
            nArray[n2] = nArray[n2] + 1;
            if (nArray[(Integer)object] == n && state2.getFinalWeight() != semiring.zero()) break;
            if (nArray[(Integer)object] > n) continue;
            for (int i = 0; i < state2.getNumArcs(); ++i) {
                Arc arc = state2.getArc(i);
                float f2 = semiring.times(f.floatValue(), arc.getWeight());
                Pair<State, Float> pair3 = new Pair<State, Float>(arc.getNextState(), Float.valueOf(f2));
                hashMap.put(pair3, pair2);
                priorityQueue.add(pair3);
            }
        }
        return fst3;
    }
}

