/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.ImmutableFst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.operations.ProjectType;

public class Project {
    private Project() {
    }

    public static void apply(Fst fst, ProjectType projectType) {
        if (projectType == ProjectType.INPUT) {
            fst.setOsyms(fst.getIsyms());
        } else if (projectType == ProjectType.OUTPUT) {
            fst.setIsyms(fst.getOsyms());
        }
        int n = fst.getNumStates();
        for (int i = 0; i < n; ++i) {
            State state = fst.getState(i);
            int n2 = fst instanceof ImmutableFst ? state.getNumArcs() - 1 : state.getNumArcs();
            for (int j = 0; j < n2; ++j) {
                Arc arc = state.getArc(j);
                if (projectType == ProjectType.INPUT) {
                    arc.setOlabel(arc.getIlabel());
                    continue;
                }
                if (projectType != ProjectType.OUTPUT) continue;
                arc.setIlabel(arc.getOlabel());
            }
        }
    }
}

