/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.operations.Connect;
import edu.cmu.sphinx.fst.semiring.Semiring;
import java.util.HashMap;

public class RmEpsilon {
    private RmEpsilon() {
    }

    private static void put(State state, State state2, float f, HashMap<State, Float>[] hashMapArray) {
        HashMap<State, Float> hashMap = hashMapArray[state.getId()];
        if (hashMap == null) {
            hashMapArray[state.getId()] = hashMap = new HashMap();
        }
        hashMap.put(state2, Float.valueOf(f));
    }

    private static void add(State state, State state2, float f, HashMap<State, Float>[] hashMapArray, Semiring semiring) {
        Float f2 = RmEpsilon.getPathWeight(state, state2, hashMapArray);
        if (f2 == null) {
            RmEpsilon.put(state, state2, f, hashMapArray);
        } else {
            RmEpsilon.put(state, state2, semiring.plus(f, f2.floatValue()), hashMapArray);
        }
    }

    private static void calcClosure(Fst fst, State state, HashMap<State, Float>[] hashMapArray, Semiring semiring) {
        State state2 = state;
        int n = state2.getNumArcs();
        for (int i = 0; i < n; ++i) {
            Arc arc = state2.getArc(i);
            if (arc.getIlabel() != 0 || arc.getOlabel() != 0) continue;
            if (hashMapArray[arc.getNextState().getId()] == null) {
                RmEpsilon.calcClosure(fst, arc.getNextState(), hashMapArray, semiring);
            }
            if (hashMapArray[arc.getNextState().getId()] != null) {
                for (State state3 : hashMapArray[arc.getNextState().getId()].keySet()) {
                    float f = semiring.times(RmEpsilon.getPathWeight(arc.getNextState(), state3, hashMapArray).floatValue(), arc.getWeight());
                    RmEpsilon.add(state, state3, f, hashMapArray, semiring);
                }
            }
            RmEpsilon.add(state, arc.getNextState(), arc.getWeight(), hashMapArray, semiring);
        }
    }

    private static Float getPathWeight(State state, State state2, HashMap<State, Float>[] hashMapArray) {
        if (hashMapArray[state.getId()] != null) {
            return hashMapArray[state.getId()].get(state2);
        }
        return null;
    }

    public static Fst get(Fst fst) {
        Object object;
        State state;
        State state2;
        int n;
        if (fst == null) {
            return null;
        }
        if (fst.getSemiring() == null) {
            return null;
        }
        Semiring semiring = fst.getSemiring();
        Fst fst2 = new Fst(semiring);
        HashMap[] hashMapArray = new HashMap[fst.getNumStates()];
        State[] stateArray = new State[fst.getNumStates()];
        State[] stateArray2 = new State[fst.getNumStates()];
        int n2 = fst.getNumStates();
        for (n = 0; n < n2; ++n) {
            state2 = fst.getState(n);
            state = new State(state2.getFinalWeight());
            fst2.addState(state);
            stateArray[state2.getId()] = state;
            stateArray2[state.getId()] = state2;
            if (state.getId() != fst.getStart().getId()) continue;
            fst2.setStart(state);
        }
        for (n = 0; n < n2; ++n) {
            state2 = fst.getState(n);
            state = stateArray[state2.getId()];
            int n3 = state2.getNumArcs();
            for (int i = 0; i < n3; ++i) {
                object = state2.getArc(i);
                if (((Arc)object).getIlabel() == 0 && ((Arc)object).getOlabel() == 0) continue;
                state.addArc(new Arc(((Arc)object).getIlabel(), ((Arc)object).getOlabel(), ((Arc)object).getWeight(), stateArray[((Arc)object).getNextState().getId()]));
            }
            if (hashMapArray[state2.getId()] != null) continue;
            RmEpsilon.calcClosure(fst, state2, hashMapArray, semiring);
        }
        n2 = fst2.getNumStates();
        for (n = 0; n < n2; ++n) {
            state2 = fst2.getState(n);
            state = stateArray2[state2.getId()];
            if (hashMapArray[state.getId()] == null) continue;
            for (State state3 : hashMapArray[state.getId()].keySet()) {
                object = state3;
                if (((State)object).getFinalWeight() != semiring.zero()) {
                    state2.setFinalWeight(semiring.plus(state2.getFinalWeight(), semiring.times(RmEpsilon.getPathWeight(state, (State)object, hashMapArray).floatValue(), ((State)object).getFinalWeight())));
                }
                int n4 = ((State)object).getNumArcs();
                for (int i = 0; i < n4; ++i) {
                    Arc arc = ((State)object).getArc(i);
                    if (arc.getIlabel() == 0 && arc.getOlabel() == 0) continue;
                    Arc arc2 = new Arc(arc.getIlabel(), arc.getOlabel(), semiring.times(arc.getWeight(), RmEpsilon.getPathWeight(state, (State)object, hashMapArray).floatValue()), stateArray[arc.getNextState().getId()]);
                    state2.addArc(arc2);
                }
            }
        }
        fst2.setIsyms(fst.getIsyms());
        fst2.setOsyms(fst.getOsyms());
        Connect.apply(fst2);
        return fst2;
    }
}

