/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.sequitur;

import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.semiring.TropicalSemiring;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;

public class SequiturImport {
    public static void main(String ... stringArray) throws JAXBException, IOException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{FSA.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        FSA fSA = (FSA)unmarshaller.unmarshal(new File(stringArray[0]));
        Fst fst = fSA.toFst();
        fst.saveModel(stringArray[1]);
        System.out.println("The Sequitur G2P XML-formatted FST " + stringArray[0] + " has been converted to Sphinx' OpenFst binary format in the file " + stringArray[1]);
    }

    public static class Arc {
        @XmlAttribute
        int target;
        @XmlElement
        int in;
        @XmlElement
        int out;
        @XmlElement
        float weight;

        public void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
            ++this.target;
        }

        public edu.cmu.sphinx.fst.Arc toOpenFstArc(List<edu.cmu.sphinx.fst.State> list) {
            return new edu.cmu.sphinx.fst.Arc(this.in, this.out, this.weight, list.get(this.target));
        }
    }

    public static class State {
        @XmlAttribute
        int id;
        @XmlElement(name="final")
        Object finalState;
        @XmlElement
        Float weight;
        @XmlElement(name="arc")
        List<Arc> arcs;

        public void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
            ++this.id;
        }

        public edu.cmu.sphinx.fst.State toUnconnectedOpenFstState() {
            return new edu.cmu.sphinx.fst.State(this.weight != null ? this.weight.floatValue() : 0.0f);
        }

        public void connectStates(List<edu.cmu.sphinx.fst.State> list) {
            if (this.arcs != null) {
                for (Arc arc : this.arcs) {
                    edu.cmu.sphinx.fst.Arc arc2 = arc.toOpenFstArc(list);
                    list.get(this.id).addArc(arc2);
                }
            }
        }
    }

    public static class Symbol {
        @XmlAttribute
        Integer index;
        @XmlMixed
        List<String> contentList;
        transient String content;

        public void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
            assert (this.contentList != null) : "Error with symbol " + this.index;
            assert (this.contentList.size() == 1) : "Error with symbol " + this.index;
            this.content = this.contentList.get(0);
            if (this.content.equals("__term__")) {
                this.content = "</s>";
            } else if (this.content.matches("__.+__")) {
                this.content = "<eps>";
            }
        }
    }

    public static class Alphabet {
        @XmlElement(name="symbol")
        List<Symbol> symbols;

        public void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
            Iterator<Symbol> iterator = this.symbols.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().content.matches("__\\d+__")) continue;
                iterator.remove();
            }
            for (int i = 0; i < this.symbols.size(); ++i) {
                assert (this.symbols.get((int)i).index != null);
                assert (this.symbols.get((int)i).index == i);
                this.symbols.get((int)i).index = null;
            }
            Symbol symbol = new Symbol();
            symbol.content = "<s>";
            this.symbols.add(symbol);
        }

        String[] toSymbols() {
            String[] stringArray = new String[this.symbols.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.symbols.get((int)i).content;
            }
            return stringArray;
        }
    }

    @XmlRootElement(name="fsa")
    public static class FSA {
        @XmlAttribute
        String semiring;
        @XmlAttribute
        int initial;
        @XmlElement(name="input-alphabet")
        Alphabet inputAlphabet;
        @XmlElement(name="output-alphabet")
        Alphabet outputAlphabet;
        @XmlElement(name="state")
        List<State> states;
        transient List<edu.cmu.sphinx.fst.State> openFstStates;
        transient Semiring ring = new TropicalSemiring();

        public void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
            assert ("tropical".equals(this.semiring));
            State state = new State();
            state.id = 0;
            Arc arc = new Arc();
            arc.in = this.inputAlphabet.symbols.size() - 1;
            arc.out = this.outputAlphabet.symbols.size() - 1;
            arc.target = this.initial + 1;
            arc.weight = this.ring.one();
            state.arcs = Collections.singletonList(arc);
            this.states.add(state);
            Collections.sort(this.states, new Comparator<State>(){

                @Override
                public int compare(State state, State state2) {
                    return state.id - state2.id;
                }
            });
        }

        public Fst toFst() {
            Fst fst = new Fst(this.ring);
            fst.setIsyms(this.inputAlphabet.toSymbols());
            fst.setOsyms(this.outputAlphabet.toSymbols());
            this.openFstStates = new ArrayList<edu.cmu.sphinx.fst.State>(this.states.size());
            for (State state : this.states) {
                edu.cmu.sphinx.fst.State state2 = state.toUnconnectedOpenFstState();
                fst.addState(state2);
                assert (state2.getId() == state.id);
                this.openFstStates.add(state2);
            }
            fst.setStart(this.openFstStates.get(0));
            for (State state : this.states) {
                state.connectStates(this.openFstStates);
            }
            return fst;
        }
    }
}

