/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.instrumentation.Resetable;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.NISTAlign;
import edu.cmu.sphinx.util.props.ConfigurableAdapter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;

public abstract class AccuracyTracker
extends ConfigurableAdapter
implements ResultListener,
Resetable,
StateListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_SUMMARY = "showSummary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_DETAILS = "showDetails";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_RESULTS = "showResults";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_ALIGNED_RESULTS = "showAlignedResults";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_RAW_RESULTS = "showRawResults";
    private String name;
    private Recognizer recognizer;
    private boolean showSummary;
    private boolean showDetails;
    private boolean showResults;
    private boolean showAlignedResults;
    private boolean showRaw;
    private final NISTAlign aligner = new NISTAlign(false, false);

    public AccuracyTracker(Recognizer recognizer, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.initRecognizer(recognizer);
        this.initLogger();
        this.showSummary = bl;
        this.showDetails = bl2;
        this.showResults = bl3;
        this.showAlignedResults = bl4;
        this.showRaw = bl5;
        this.aligner.setShowResults(bl3);
        this.aligner.setShowAlignedResults(bl4);
    }

    public AccuracyTracker() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.initRecognizer((Recognizer)propertySheet.getComponent(PROP_RECOGNIZER));
        this.showSummary = propertySheet.getBoolean(PROP_SHOW_SUMMARY);
        this.showDetails = propertySheet.getBoolean(PROP_SHOW_DETAILS);
        this.showResults = propertySheet.getBoolean(PROP_SHOW_RESULTS);
        this.showAlignedResults = propertySheet.getBoolean(PROP_SHOW_ALIGNED_RESULTS);
        this.showRaw = propertySheet.getBoolean(PROP_SHOW_RAW_RESULTS);
        this.aligner.setShowResults(this.showResults);
        this.aligner.setShowAlignedResults(this.showAlignedResults);
    }

    private void initRecognizer(Recognizer recognizer) {
        if (this.recognizer == null) {
            this.recognizer = recognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != recognizer) {
            this.recognizer.removeResultListener(this);
            this.recognizer.removeStateListener(this);
            this.recognizer = recognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        }
    }

    @Override
    public void reset() {
        this.aligner.resetTotals();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public NISTAlign getAligner() {
        return this.aligner;
    }

    protected void showDetails(String string) {
        if (this.showDetails) {
            this.aligner.printSentenceSummary();
            if (this.showRaw) {
                this.logger.info("RAW     " + string);
            }
            this.aligner.printTotalSummary();
        }
    }

    @Override
    public abstract void newResult(Result var1);

    @Override
    public void statusChanged(Recognizer.State state) {
        if (state == Recognizer.State.DEALLOCATED && this.showSummary) {
            this.logger.info("\n# --------------- Summary statistics ---------");
            this.aligner.printTotalSummary();
        }
    }
}

