/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.instrumentation.AccuracyTracker;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;

public class BestPathAccuracyTracker
extends AccuracyTracker {
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_FULL_PATH = "showFullPath";
    private boolean showFullPath;

    public BestPathAccuracyTracker(Recognizer recognizer, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(recognizer, bl, bl2, bl3, bl4, bl5);
        this.showFullPath = bl6;
    }

    public BestPathAccuracyTracker() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.showFullPath = propertySheet.getBoolean(PROP_SHOW_FULL_PATH);
    }

    private void showFullPath(Result result) {
        if (this.showFullPath) {
            System.out.println();
            Token token = result.getBestToken();
            if (token != null) {
                token.dumpTokenPath();
            } else {
                System.out.println("Null result");
            }
            System.out.println();
        }
    }

    @Override
    public void newResult(Result result) {
        String string = result.getReferenceText();
        if (result.isFinal() && string != null) {
            String string2 = result.getBestResultNoFiller();
            this.getAligner().align(string, string2);
            this.showFullPath(result);
            this.showDetails(result.toString());
        }
    }
}

