/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4String;
import edu.cmu.sphinx.util.props.tools.GDLDumper;
import edu.cmu.sphinx.util.props.tools.HTMLDumper;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class ConfigMonitor
implements Configurable,
Runnable,
Monitor {
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_CONFIG = "showConfig";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_CONFIG_AS_HTML = "showConfigAsHTML";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_CONFIG_AS_GDL = "showConfigAsGDL";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SAVE_CONFIG_AS_XML = "saveConfigAsXML";
    @S4String(mandatory=false)
    public static final String PROP_OUTFILE = "file";
    private boolean showConfig;
    private boolean showHTML = true;
    private boolean saveXML;
    private boolean showGDL = true;
    private Logger logger;
    private ConfigurationManager cm;
    private String htmlPath = "config.html";
    private String gdlPath = "config.gdl";
    private String xmlPath = "config.xml";

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        File file;
        this.logger = propertySheet.getLogger();
        this.cm = ConfigurationManagerUtils.getPropertyManager(propertySheet);
        this.showConfig = propertySheet.getBoolean(PROP_SHOW_CONFIG);
        this.showHTML = propertySheet.getBoolean(PROP_SHOW_CONFIG_AS_HTML);
        this.showGDL = propertySheet.getBoolean(PROP_SHOW_CONFIG_AS_GDL);
        this.saveXML = propertySheet.getBoolean(PROP_SAVE_CONFIG_AS_XML);
        if (propertySheet.getString(PROP_OUTFILE) != null && (file = new File(propertySheet.getString(PROP_OUTFILE))).getParentFile().isDirectory()) {
            this.htmlPath = file.getPath();
            this.gdlPath = file.getPath();
            this.xmlPath = file.getPath();
        }
    }

    @Override
    public void run() {
        if (this.showConfig) {
            ConfigurationManagerUtils.showConfig(this.cm);
        }
        if (this.showHTML) {
            try {
                HTMLDumper.showConfigAsHTML(this.cm, "foo.html");
            }
            catch (IOException iOException) {
                this.logger.warning("Can't open " + this.htmlPath + ' ' + iOException);
            }
        }
        if (this.showGDL) {
            try {
                GDLDumper.showConfigAsGDL(this.cm, this.gdlPath);
            }
            catch (IOException iOException) {
                this.logger.warning("Can't open " + this.gdlPath + ' ' + iOException);
            }
        }
        if (this.saveXML) {
            ConfigurationManagerUtils.save(this.cm, new File(this.xmlPath));
        }
    }
}

