/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.ConfigurableAdapter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.text.DecimalFormat;

public class MemoryTracker
extends ConfigurableAdapter
implements ResultListener,
StateListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_SUMMARY = "showSummary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_DETAILS = "showDetails";
    private static final DecimalFormat memFormat = new DecimalFormat("0.00 Mb");
    private String name;
    private Recognizer recognizer;
    private boolean showSummary;
    private boolean showDetails;
    private float maxMemoryUsed;
    private int numMemoryStats;
    private float avgMemoryUsed;

    public MemoryTracker(Recognizer recognizer, boolean bl, boolean bl2) {
        this.initRecognizer(recognizer);
        this.initLogger();
        this.showSummary = bl;
        this.showDetails = bl2;
    }

    public MemoryTracker() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        Recognizer recognizer = (Recognizer)propertySheet.getComponent(PROP_RECOGNIZER);
        this.initRecognizer(recognizer);
        this.showSummary = propertySheet.getBoolean(PROP_SHOW_SUMMARY);
        this.showDetails = propertySheet.getBoolean(PROP_SHOW_DETAILS);
    }

    private void initRecognizer(Recognizer recognizer) {
        if (this.recognizer == null) {
            this.recognizer = recognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != recognizer) {
            this.recognizer.removeResultListener(this);
            this.recognizer.removeStateListener(this);
            this.recognizer = recognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void calculateMemoryUsage(boolean bl) {
        float f;
        float f2 = (float)Runtime.getRuntime().totalMemory() / 1048576.0f;
        float f3 = f2 - (f = (float)Runtime.getRuntime().freeMemory() / 1048576.0f);
        if (f3 > this.maxMemoryUsed) {
            this.maxMemoryUsed = f3;
        }
        ++this.numMemoryStats;
        this.avgMemoryUsed = (this.avgMemoryUsed * (float)(this.numMemoryStats - 1) + f3) / (float)this.numMemoryStats;
        if (bl) {
            this.logger.info("   Mem  Total: " + memFormat.format(f2) + "  " + "Free: " + memFormat.format(f));
            this.logger.info("   Used: This: " + memFormat.format(f3) + "  " + "Avg: " + memFormat.format(this.avgMemoryUsed) + "  " + "Max: " + memFormat.format(this.maxMemoryUsed));
        }
    }

    @Override
    public void newResult(Result result) {
        if (result.isFinal()) {
            this.calculateMemoryUsage(this.showDetails);
        }
    }

    @Override
    public void statusChanged(Recognizer.State state) {
        if (state == Recognizer.State.DEALLOCATED) {
            this.calculateMemoryUsage(this.showSummary);
        }
    }
}

