/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.List;

public class RecognizerMonitor
implements StateListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4ComponentList(type=Configurable.class)
    public static final String PROP_ALLOCATED_MONITORS = "allocatedMonitors";
    @S4ComponentList(type=Configurable.class)
    public static final String PROP_DEALLOCATED_MONITORS = "deallocatedMonitors";
    Recognizer recognizer;
    List<Runnable> allocatedMonitors;
    List<Runnable> deallocatedMonitors;
    String name;

    public RecognizerMonitor(Recognizer recognizer, List<Runnable> list, List<Runnable> list2) {
        this.initRecognizer(recognizer);
        this.allocatedMonitors = list;
        this.deallocatedMonitors = list2;
    }

    public RecognizerMonitor() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.initRecognizer((Recognizer)propertySheet.getComponent(PROP_RECOGNIZER));
        this.allocatedMonitors = propertySheet.getComponentList(PROP_ALLOCATED_MONITORS, Runnable.class);
        this.deallocatedMonitors = propertySheet.getComponentList(PROP_DEALLOCATED_MONITORS, Runnable.class);
    }

    private void initRecognizer(Recognizer recognizer) {
        if (this.recognizer == null) {
            this.recognizer = recognizer;
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != recognizer) {
            this.recognizer.removeStateListener(this);
            this.recognizer = recognizer;
            this.recognizer.addStateListener(this);
        }
    }

    @Override
    public void statusChanged(Recognizer.State state) {
        List<Runnable> list = null;
        if (state == Recognizer.State.ALLOCATED) {
            list = this.allocatedMonitors;
        } else if (state == Recognizer.State.DEALLOCATED) {
            list = this.deallocatedMonitors;
        }
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
    }
}

