/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.instrumentation.Resetable;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;

public class RejectionTracker
implements ResultListener,
Resetable,
Monitor,
StateListener {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_SUMMARY = "showSummary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_DETAILS = "showDetails";
    private String name;
    private Recognizer recognizer;
    private boolean showSummary;
    private boolean showDetails;
    private int numUtterances;
    private int numOutOfGrammarUtterances;
    private int numCorrectOutOfGrammarUtterances;
    private int numFalseOutOfGrammarUtterances;
    private int numCorrectInGrammarUtterances;
    private int numFalseInGrammarUtterances;

    public RejectionTracker(Recognizer recognizer, boolean bl, boolean bl2) {
        this.initRecognizer(recognizer);
        this.showSummary = bl;
        this.showDetails = bl2;
    }

    public RejectionTracker() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.initRecognizer((Recognizer)propertySheet.getComponent(PROP_RECOGNIZER));
        this.showSummary = propertySheet.getBoolean(PROP_SHOW_SUMMARY);
        this.showDetails = propertySheet.getBoolean(PROP_SHOW_DETAILS);
    }

    private void initRecognizer(Recognizer recognizer) {
        if (this.recognizer == null) {
            this.recognizer = recognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != recognizer) {
            this.recognizer.removeResultListener(this);
            this.recognizer.removeStateListener(this);
            this.recognizer = recognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        }
    }

    @Override
    public void reset() {
        this.numUtterances = 0;
        this.numOutOfGrammarUtterances = 0;
        this.numCorrectOutOfGrammarUtterances = 0;
        this.numFalseOutOfGrammarUtterances = 0;
        this.numCorrectInGrammarUtterances = 0;
        this.numFalseInGrammarUtterances = 0;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void newResult(Result result) {
        String string = result.getReferenceText();
        if (result.isFinal() && string != null) {
            ++this.numUtterances;
            String string2 = result.getBestResultNoFiller();
            if (string.equals("<unk>")) {
                ++this.numOutOfGrammarUtterances;
                if (string2.equals("<unk>")) {
                    ++this.numCorrectOutOfGrammarUtterances;
                } else {
                    ++this.numFalseInGrammarUtterances;
                }
            } else if (string2.equals("<unk>")) {
                ++this.numFalseOutOfGrammarUtterances;
            } else {
                ++this.numCorrectInGrammarUtterances;
            }
            this.printStats();
        }
    }

    private void printStats() {
        if (this.showSummary) {
            float f = (float)(this.numCorrectOutOfGrammarUtterances + this.numCorrectInGrammarUtterances) / (float)this.numUtterances * 100.0f;
            System.out.println("   Rejection Accuracy: " + f + '%');
        }
        if (this.showDetails) {
            System.out.println("   Correct OOG: " + this.numCorrectOutOfGrammarUtterances + "   False OOG: " + this.numFalseOutOfGrammarUtterances + "   Correct IG: " + this.numCorrectInGrammarUtterances + "   False IG: " + this.numFalseInGrammarUtterances + "   Actual number: " + this.numOutOfGrammarUtterances);
        }
    }

    @Override
    public void statusChanged(Recognizer.State state) {
        if (state == Recognizer.State.DEALLOCATED) {
            this.printStats();
        }
    }
}

