/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.SignalListener;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.instrumentation.Resetable;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.ConfigurableAdapter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.text.DecimalFormat;

public class SpeedTracker
extends ConfigurableAdapter
implements ResultListener,
Resetable,
StateListener,
SignalListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Component(type=FrontEnd.class)
    public static final String PROP_FRONTEND = "frontend";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_SUMMARY = "showSummary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_DETAILS = "showDetails";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_RESPONSE_TIME = "showResponseTime";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_TIMERS = "showTimers";
    private static final DecimalFormat timeFormat = new DecimalFormat("0.00");
    private String name;
    private Recognizer recognizer;
    private FrontEnd frontEnd;
    private boolean showSummary;
    private boolean showDetails;
    private boolean showTimers;
    private long startTime;
    private long audioStartTime;
    private float audioTime;
    private float processingTime;
    private float totalAudioTime;
    private float totalProcessingTime;
    private boolean showResponseTime;
    private int numUtteranceStart;
    private long maxResponseTime = Long.MIN_VALUE;
    private long minResponseTime = Long.MAX_VALUE;
    private long totalResponseTime;

    public SpeedTracker(Recognizer recognizer, FrontEnd frontEnd, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.initLogger();
        this.initRecognizer(recognizer);
        this.initFrontEnd(frontEnd);
        this.showSummary = bl;
        this.showDetails = bl2;
        this.showResponseTime = bl3;
        this.showTimers = bl4;
    }

    public SpeedTracker() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.initRecognizer((Recognizer)propertySheet.getComponent(PROP_RECOGNIZER));
        this.initFrontEnd((FrontEnd)propertySheet.getComponent(PROP_FRONTEND));
        this.showSummary = propertySheet.getBoolean(PROP_SHOW_SUMMARY);
        this.showDetails = propertySheet.getBoolean(PROP_SHOW_DETAILS);
        this.showResponseTime = propertySheet.getBoolean(PROP_SHOW_RESPONSE_TIME);
        this.showTimers = propertySheet.getBoolean(PROP_SHOW_TIMERS);
    }

    private void initFrontEnd(FrontEnd frontEnd) {
        if (this.frontEnd == null) {
            this.frontEnd = frontEnd;
            this.frontEnd.addSignalListener(this);
        } else if (this.frontEnd != frontEnd) {
            this.frontEnd.removeSignalListener(this);
            this.frontEnd = frontEnd;
            this.frontEnd.addSignalListener(this);
        }
    }

    private void initRecognizer(Recognizer recognizer) {
        if (this.recognizer == null) {
            this.recognizer = recognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != recognizer) {
            this.recognizer.removeResultListener(this);
            this.recognizer.removeStateListener(this);
            this.recognizer = recognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void newResult(Result result) {
        if (result.isFinal()) {
            this.processingTime = (float)(this.getTime() - this.startTime) / 1000.0f;
            this.totalAudioTime += this.audioTime;
            this.totalProcessingTime += this.processingTime;
            if (this.showDetails) {
                this.showAudioUsage();
            }
        }
    }

    protected void showAudioUsage() {
        this.logger.info("   This  Time Audio: " + timeFormat.format(this.audioTime) + "s" + "  Proc: " + timeFormat.format(this.processingTime) + "s" + "  Speed: " + timeFormat.format(this.getSpeed()) + " X real time");
        this.showAudioSummary();
    }

    protected void showAudioSummary() {
        this.logger.info("   Total Time Audio: " + timeFormat.format(this.totalAudioTime) + "s" + "  Proc: " + timeFormat.format(this.totalProcessingTime) + "s " + timeFormat.format(this.getCumulativeSpeed()) + " X real time");
        if (this.showResponseTime) {
            float f = (float)this.totalResponseTime / (float)(this.numUtteranceStart * 1000);
            this.logger.info("   Response Time:  Avg: " + f + 's' + "  Max: " + (float)this.maxResponseTime / 1000.0f + "s  Min: " + (float)this.minResponseTime / 1000.0f + 's');
        }
    }

    public float getSpeed() {
        if (this.processingTime == 0.0f || this.audioTime == 0.0f) {
            return 0.0f;
        }
        return this.processingTime / this.audioTime;
    }

    @Override
    public void reset() {
        this.totalProcessingTime = 0.0f;
        this.totalAudioTime = 0.0f;
        this.numUtteranceStart = 0;
    }

    public float getCumulativeSpeed() {
        if (this.totalProcessingTime == 0.0f || this.totalAudioTime == 0.0f) {
            return 0.0f;
        }
        return this.totalProcessingTime / this.totalAudioTime;
    }

    @Override
    public void signalOccurred(Signal signal) {
        if (signal instanceof SpeechStartSignal || signal instanceof DataStartSignal) {
            this.startTime = this.getTime();
            this.audioStartTime = signal.getTime();
            long l = this.startTime - this.audioStartTime;
            this.totalResponseTime += l;
            if (l > this.maxResponseTime) {
                this.maxResponseTime = l;
            }
            if (l < this.minResponseTime) {
                this.minResponseTime = l;
            }
            ++this.numUtteranceStart;
        } else if (signal instanceof SpeechEndSignal) {
            this.audioTime = (float)(signal.getTime() - this.audioStartTime) / 1000.0f;
        } else if (signal instanceof DataEndSignal) {
            this.audioTime = (float)((DataEndSignal)signal).getDuration() / 1000.0f;
        }
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void statusChanged(Recognizer.State state) {
        if (state == Recognizer.State.ALLOCATED && this.showTimers) {
            TimerPool.dumpAll(this.logger);
        }
        if (state == Recognizer.State.DEALLOCATING && this.showTimers) {
            TimerPool.dumpAll(this.logger);
        }
        if (state == Recognizer.State.DEALLOCATED && this.showSummary) {
            this.showAudioSummary();
        }
    }
}

