/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.GrXMLHandler;
import edu.cmu.sphinx.jsgf.JSGFGrammar;
import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFGrammarParseException;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class GrXMLGrammar
extends JSGFGrammar {
    Map<String, JSGFRule> rules;

    protected void loadXML() throws IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            this.rules = new HashMap<String, JSGFRule>();
            GrXMLHandler grXMLHandler = new GrXMLHandler(this.baseURL, this.rules, this.logger);
            xMLReader.setContentHandler(grXMLHandler);
            xMLReader.setErrorHandler(grXMLHandler);
            InputStream inputStream = this.baseURL.openStream();
            xMLReader.parse(new InputSource(inputStream));
            inputStream.close();
        }
        catch (SAXParseException sAXParseException) {
            String string = "Error while parsing line " + sAXParseException.getLineNumber() + " of " + this.baseURL + ": " + sAXParseException.getMessage();
            throw new IOException(string);
        }
        catch (SAXException sAXException) {
            throw new IOException("Problem with XML: " + sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    @Override
    public void commitChanges() throws IOException, JSGFGrammarParseException, JSGFGrammarException {
        try {
            if (this.loadGrammar) {
                if (this.manager == null) {
                    this.getGrammarManager();
                }
                this.loadXML();
                this.loadGrammar = false;
            }
            this.ruleStack = new JSGFGrammar.RuleStack(this);
            this.newGrammar();
            this.firstNode = this.createGrammarNode("<sil>");
            GrammarNode grammarNode = this.createGrammarNode("<sil>");
            grammarNode.setFinalNode(true);
            for (Map.Entry<String, JSGFRule> entry : this.rules.entrySet()) {
                JSGFGrammar.GrammarGraph grammarGraph = new JSGFGrammar.GrammarGraph(this);
                this.ruleStack.push(entry.getKey(), grammarGraph);
                JSGFGrammar.GrammarGraph grammarGraph2 = this.processRule(entry.getValue());
                this.ruleStack.pop();
                this.firstNode.add(grammarGraph.getStartNode(), 0.0f);
                grammarGraph.getEndNode().add(grammarNode, 0.0f);
                grammarGraph.getStartNode().add(grammarGraph2.getStartNode(), 0.0f);
                grammarGraph2.getEndNode().add(grammarGraph.getEndNode(), 0.0f);
            }
            this.postProcessGrammar();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("bad base grammar URL " + this.baseURL + ' ' + malformedURLException);
        }
    }
}

