/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFGrammarParseException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammar;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarFactory;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarManager;
import edu.cmu.sphinx.jsgf.parser.JSGFParser;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleAlternatives;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleCount;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleName;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleSequence;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleTag;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleToken;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSGFGrammar
extends Grammar {
    @S4String
    public static final String PROP_BASE_GRAMMAR_URL = "grammarLocation";
    @S4String(defaultValue="default.gram")
    public static final String PROP_GRAMMAR_NAME = "grammarName";
    private JSGFRuleGrammar ruleGrammar;
    protected JSGFRuleGrammarManager manager;
    protected RuleStack ruleStack;
    private String grammarName;
    protected URL baseURL;
    private LogMath logMath;
    protected boolean loadGrammar = true;
    protected GrammarNode firstNode;
    protected Logger logger;

    public JSGFGrammar(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Dictionary dictionary) throws MalformedURLException, ClassNotFoundException {
        this(ConfigurationManagerUtils.resourceToURL(string), string2, bl, bl2, bl3, bl4, dictionary);
    }

    public JSGFGrammar(URL uRL, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Dictionary dictionary) {
        super(bl, bl2, bl3, bl4, dictionary);
        this.logMath = LogMath.getLogMath();
        this.baseURL = uRL;
        this.grammarName = string;
        this.loadGrammar = true;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public JSGFGrammar() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.baseURL = ConfigurationManagerUtils.getResource(PROP_BASE_GRAMMAR_URL, propertySheet);
        this.logger = propertySheet.getLogger();
        this.grammarName = propertySheet.getString(PROP_GRAMMAR_NAME);
        this.loadGrammar = true;
    }

    public JSGFRuleGrammar getRuleGrammar() {
        return this.ruleGrammar;
    }

    public JSGFRuleGrammarManager getGrammarManager() {
        if (this.manager == null) {
            this.manager = new JSGFRuleGrammarManager();
        }
        return this.manager;
    }

    public void setBaseURL(URL uRL) {
        this.baseURL = uRL;
    }

    public String getGrammarName() {
        return this.grammarName;
    }

    public void loadJSGF(String string) throws IOException, JSGFGrammarParseException, JSGFGrammarException {
        this.grammarName = string;
        this.loadGrammar = true;
        this.commitChanges();
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        try {
            this.commitChanges();
        }
        catch (JSGFGrammarException jSGFGrammarException) {
            throw new IOException(jSGFGrammarException);
        }
        catch (JSGFGrammarParseException jSGFGrammarParseException) {
            throw new IOException(jSGFGrammarParseException);
        }
        return this.firstNode;
    }

    @Override
    public GrammarNode getInitialNode() {
        return this.firstNode;
    }

    protected GrammarGraph processRule(JSGFRule jSGFRule) throws JSGFGrammarException {
        GrammarGraph grammarGraph;
        if (jSGFRule != null) {
            this.logger.fine("parseRule: " + jSGFRule);
        }
        if (jSGFRule instanceof JSGFRuleAlternatives) {
            grammarGraph = this.processRuleAlternatives((JSGFRuleAlternatives)jSGFRule);
        } else if (jSGFRule instanceof JSGFRuleCount) {
            grammarGraph = this.processRuleCount((JSGFRuleCount)jSGFRule);
        } else if (jSGFRule instanceof JSGFRuleName) {
            grammarGraph = this.processRuleName((JSGFRuleName)jSGFRule);
        } else if (jSGFRule instanceof JSGFRuleSequence) {
            grammarGraph = this.processRuleSequence((JSGFRuleSequence)jSGFRule);
        } else if (jSGFRule instanceof JSGFRuleTag) {
            grammarGraph = this.processRuleTag((JSGFRuleTag)jSGFRule);
        } else if (jSGFRule instanceof JSGFRuleToken) {
            grammarGraph = this.processRuleToken((JSGFRuleToken)jSGFRule);
        } else {
            throw new IllegalArgumentException("Unsupported Rule type: " + jSGFRule);
        }
        return grammarGraph;
    }

    private GrammarGraph processRuleName(JSGFRuleName jSGFRuleName) throws JSGFGrammarException {
        this.logger.fine("parseRuleName: " + jSGFRuleName);
        GrammarGraph grammarGraph = this.ruleStack.contains(jSGFRuleName.getRuleName());
        if (grammarGraph != null) {
            return grammarGraph;
        }
        grammarGraph = new GrammarGraph();
        this.ruleStack.push(jSGFRuleName.getRuleName(), grammarGraph);
        JSGFRuleName jSGFRuleName2 = this.ruleGrammar.resolve(jSGFRuleName);
        if (jSGFRuleName2 == JSGFRuleName.NULL) {
            grammarGraph.getStartNode().add(grammarGraph.getEndNode(), 0.0f);
        } else if (jSGFRuleName2 != JSGFRuleName.VOID) {
            if (jSGFRuleName2 == null) {
                throw new JSGFGrammarException("Can't resolve " + jSGFRuleName + " g " + jSGFRuleName.getFullGrammarName());
            }
            JSGFRuleGrammar jSGFRuleGrammar = this.manager.retrieveGrammar(jSGFRuleName2.getFullGrammarName());
            if (jSGFRuleGrammar == null) {
                throw new JSGFGrammarException("Can't resolve grammar name " + jSGFRuleName2.getFullGrammarName());
            }
            JSGFRule jSGFRule = jSGFRuleGrammar.getRule(jSGFRuleName2.getSimpleRuleName());
            if (jSGFRule == null) {
                throw new JSGFGrammarException("Can't resolve rule: " + jSGFRuleName2.getRuleName());
            }
            GrammarGraph grammarGraph2 = this.processRule(jSGFRule);
            if (grammarGraph != grammarGraph2) {
                grammarGraph.getStartNode().add(grammarGraph2.getStartNode(), 0.0f);
                grammarGraph2.getEndNode().add(grammarGraph.getEndNode(), 0.0f);
            }
        }
        this.ruleStack.pop();
        return grammarGraph;
    }

    private GrammarGraph processRuleCount(JSGFRuleCount jSGFRuleCount) throws JSGFGrammarException {
        this.logger.fine("parseRuleCount: " + jSGFRuleCount);
        GrammarGraph grammarGraph = new GrammarGraph();
        int n = jSGFRuleCount.getCount();
        GrammarGraph grammarGraph2 = this.processRule(jSGFRuleCount.getRule());
        grammarGraph.getStartNode().add(grammarGraph2.getStartNode(), 0.0f);
        grammarGraph2.getEndNode().add(grammarGraph.getEndNode(), 0.0f);
        if (n == 4 || n == 2) {
            grammarGraph.getStartNode().add(grammarGraph.getEndNode(), 0.0f);
        }
        if (n == 3 || n == 4) {
            grammarGraph2.getEndNode().add(grammarGraph2.getStartNode(), 0.0f);
        }
        return grammarGraph;
    }

    private GrammarGraph processRuleAlternatives(JSGFRuleAlternatives jSGFRuleAlternatives) throws JSGFGrammarException {
        this.logger.fine("parseRuleAlternatives: " + jSGFRuleAlternatives);
        GrammarGraph grammarGraph = new GrammarGraph();
        List<JSGFRule> list = jSGFRuleAlternatives.getRules();
        List<Float> list2 = this.getNormalizedWeights(jSGFRuleAlternatives.getWeights());
        for (int i = 0; i < list.size(); ++i) {
            JSGFRule jSGFRule = list.get(i);
            float f = 0.0f;
            if (list2 != null) {
                f = list2.get(i).floatValue();
            }
            this.logger.fine("Alternative: " + jSGFRule);
            GrammarGraph grammarGraph2 = this.processRule(jSGFRule);
            grammarGraph.getStartNode().add(grammarGraph2.getStartNode(), f);
            grammarGraph2.getEndNode().add(grammarGraph.getEndNode(), 0.0f);
        }
        return grammarGraph;
    }

    private List<Float> getNormalizedWeights(List<Float> list) {
        if (list == null) {
            return null;
        }
        double d = 0.0;
        Object object = list.iterator();
        while (object.hasNext()) {
            float f = object.next().floatValue();
            if (f < 0.0f) {
                throw new IllegalArgumentException("Negative weight " + f);
            }
            d += (double)f;
        }
        object = new LinkedList<Float>(list);
        for (int i = 0; i < list.size(); ++i) {
            if (d == 0.0) {
                object.set(i, Float.valueOf(-3.4028235E38f));
                continue;
            }
            object.set(i, Float.valueOf(this.logMath.linearToLog((double)list.get(i).floatValue() / d)));
        }
        return object;
    }

    private GrammarGraph processRuleSequence(JSGFRuleSequence jSGFRuleSequence) throws JSGFGrammarException {
        GrammarNode grammarNode = null;
        GrammarNode grammarNode2 = null;
        this.logger.fine("parseRuleSequence: " + jSGFRuleSequence);
        List<JSGFRule> list = jSGFRuleSequence.getRules();
        GrammarNode grammarNode3 = null;
        for (int i = 0; i < list.size(); ++i) {
            JSGFRule jSGFRule = list.get(i);
            GrammarGraph grammarGraph = this.processRule(jSGFRule);
            if (i == 0) {
                grammarNode = grammarGraph.getStartNode();
            }
            if (i == list.size() - 1) {
                grammarNode2 = grammarGraph.getEndNode();
            }
            if (i > 0) {
                grammarNode3.add(grammarGraph.getStartNode(), 0.0f);
            }
            grammarNode3 = grammarGraph.getEndNode();
        }
        return new GrammarGraph(grammarNode, grammarNode2);
    }

    private GrammarGraph processRuleTag(JSGFRuleTag jSGFRuleTag) throws JSGFGrammarException {
        this.logger.fine("parseRuleTag: " + jSGFRuleTag);
        JSGFRule jSGFRule = jSGFRuleTag.getRule();
        return this.processRule(jSGFRule);
    }

    private GrammarGraph processRuleToken(JSGFRuleToken jSGFRuleToken) {
        GrammarNode grammarNode = this.createGrammarNode(jSGFRuleToken.getText());
        return new GrammarGraph(grammarNode, grammarNode);
    }

    private static URL grammarNameToURL(URL uRL, String string) throws MalformedURLException {
        URL uRL2;
        block4: {
            string = string.replace('.', '/');
            StringBuilder stringBuilder = new StringBuilder();
            if (uRL != null) {
                stringBuilder.append(uRL);
                if (stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
                    stringBuilder.append('/');
                }
            }
            stringBuilder.append(string).append(".gram");
            String string2 = stringBuilder.toString();
            uRL2 = null;
            try {
                uRL2 = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                uRL2 = ClassLoader.getSystemResource(string2);
                if (uRL2 != null) break block4;
                throw new MalformedURLException(string2);
            }
        }
        return uRL2;
    }

    public void commitChanges() throws IOException, JSGFGrammarParseException, JSGFGrammarException {
        try {
            if (this.loadGrammar) {
                if (this.manager == null) {
                    this.getGrammarManager();
                }
                this.ruleGrammar = this.loadNamedGrammar(this.grammarName);
                this.loadImports(this.ruleGrammar);
                this.loadGrammar = false;
            }
            this.manager.linkGrammars();
            this.ruleStack = new RuleStack();
            this.newGrammar();
            this.firstNode = this.createGrammarNode("<sil>");
            GrammarNode grammarNode = this.createGrammarNode("<sil>");
            grammarNode.setFinalNode(true);
            for (String string : this.ruleGrammar.getRuleNames()) {
                if (!this.ruleGrammar.isRulePublic(string)) continue;
                String string2 = this.getFullRuleName(string);
                GrammarGraph grammarGraph = new GrammarGraph();
                this.ruleStack.push(string2, grammarGraph);
                JSGFRule jSGFRule = this.ruleGrammar.getRule(string);
                GrammarGraph grammarGraph2 = this.processRule(jSGFRule);
                this.ruleStack.pop();
                this.firstNode.add(grammarGraph.getStartNode(), 0.0f);
                grammarGraph.getEndNode().add(grammarNode, 0.0f);
                grammarGraph.getStartNode().add(grammarGraph2.getStartNode(), 0.0f);
                grammarGraph2.getEndNode().add(grammarGraph.getEndNode(), 0.0f);
            }
            this.postProcessGrammar();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.dumpGrammar();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("bad base grammar URL " + this.baseURL + ' ' + malformedURLException);
        }
    }

    private void loadImports(JSGFRuleGrammar jSGFRuleGrammar) throws IOException, JSGFGrammarParseException {
        for (JSGFRuleName jSGFRuleName : jSGFRuleGrammar.imports) {
            String string = jSGFRuleName.getFullGrammarName();
            JSGFRuleGrammar jSGFRuleGrammar2 = this.getNamedRuleGrammar(string);
            if (jSGFRuleGrammar2 == null) {
                jSGFRuleGrammar2 = this.loadNamedGrammar(jSGFRuleName.getFullGrammarName());
            }
            if (jSGFRuleGrammar2 == null) continue;
            this.loadImports(jSGFRuleGrammar2);
        }
        this.loadFullQualifiedRules(jSGFRuleGrammar);
    }

    private JSGFRuleGrammar getNamedRuleGrammar(String string) {
        return this.manager.retrieveGrammar(string);
    }

    private JSGFRuleGrammar loadNamedGrammar(String string) throws JSGFGrammarParseException, IOException {
        URL uRL = JSGFGrammar.grammarNameToURL(this.baseURL, string);
        JSGFRuleGrammar jSGFRuleGrammar = JSGFParser.newGrammarFromJSGF(uRL, new JSGFRuleGrammarFactory(this.manager));
        jSGFRuleGrammar.setEnabled(true);
        return jSGFRuleGrammar;
    }

    private void loadFullQualifiedRules(JSGFRuleGrammar jSGFRuleGrammar) throws IOException, JSGFGrammarParseException {
        for (String string : jSGFRuleGrammar.getRuleNames()) {
            String string2 = jSGFRuleGrammar.getRule(string).toString();
            int n = 0;
            while (n < string2.length() && (n = string2.indexOf(60, n)) >= 0) {
                JSGFRuleName jSGFRuleName = new JSGFRuleName(string2.substring(n + 1, string2.indexOf(62, n + 1)).trim());
                n = string2.indexOf(62, n) + 1;
                if (jSGFRuleName.getFullGrammarName() == null) continue;
                String string3 = jSGFRuleName.getFullGrammarName();
                JSGFRuleGrammar jSGFRuleGrammar2 = this.getNamedRuleGrammar(string3);
                if (jSGFRuleGrammar2 == null) {
                    jSGFRuleGrammar2 = this.loadNamedGrammar(string3);
                }
                if (jSGFRuleGrammar2 == null) continue;
                this.loadImports(jSGFRuleGrammar2);
            }
        }
    }

    private String getFullRuleName(String string) throws JSGFGrammarException {
        JSGFRuleName jSGFRuleName = this.ruleGrammar.resolve(new JSGFRuleName(string));
        return jSGFRuleName.getRuleName();
    }

    protected void dumpGrammar() {
        System.out.println("Imported rules { ");
        for (JSGFRuleName object : this.ruleGrammar.getImports()) {
            System.out.println("  Import " + object.getRuleName());
        }
        System.out.println("}");
        System.out.println("Rulenames { ");
        for (String string : this.ruleGrammar.getRuleNames()) {
            System.out.println("  Name " + string);
        }
        System.out.println("}");
    }

    class RuleStack {
        private List<String> stack;
        private HashMap<String, GrammarGraph> map;

        public RuleStack() {
            this.clear();
        }

        public void push(String string, GrammarGraph grammarGraph) {
            this.stack.add(0, string);
            this.map.put(string, grammarGraph);
        }

        public void pop() {
            this.map.remove(this.stack.remove(0));
        }

        public GrammarGraph contains(String string) {
            if (this.stack.contains(string)) {
                return this.map.get(string);
            }
            return null;
        }

        public void clear() {
            this.stack = new LinkedList<String>();
            this.map = new HashMap();
        }
    }

    class GrammarGraph {
        private GrammarNode startNode;
        private GrammarNode endNode;

        GrammarGraph(GrammarNode grammarNode, GrammarNode grammarNode2) {
            this.startNode = grammarNode;
            this.endNode = grammarNode2;
        }

        GrammarGraph() {
            this.startNode = JSGFGrammar.this.createGrammarNode(false);
            this.endNode = JSGFGrammar.this.createGrammarNode(false);
        }

        GrammarNode getStartNode() {
            return this.startNode;
        }

        GrammarNode getEndNode() {
            return this.endNode;
        }
    }
}

