/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarManager;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleAlternatives;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleCount;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleName;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleSequence;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleTag;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleToken;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class JSGFRuleGrammar {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected final Map<String, JSGFRuleState> rules = new HashMap<String, JSGFRuleState>();
    protected final List<JSGFRuleName> imports = new ArrayList<JSGFRuleName>();
    protected final List<String> importedRules = new ArrayList<String>();
    protected final Map<String, Collection<String>> ruleTags = new HashMap<String, Collection<String>>();
    private String name;
    private JSGFRuleGrammarManager manager;
    Properties ruleDocComments = new Properties();
    Properties importDocComments = new Properties();
    String grammarDocComment;

    public JSGFRuleGrammar(String string, JSGFRuleGrammarManager jSGFRuleGrammarManager) {
        this.name = string;
        this.manager = jSGFRuleGrammarManager;
    }

    public void addGrammarDocComment(String string) {
        this.grammarDocComment = string;
    }

    public void addImport(JSGFRuleName jSGFRuleName) {
        if (!this.imports.contains(jSGFRuleName)) {
            this.imports.add(jSGFRuleName);
        }
    }

    public void addImportDocComment(JSGFRuleName jSGFRuleName, String string) {
        this.importDocComments.put(jSGFRuleName.toString(), string);
    }

    public void addRuleDocComment(String string, String string2) {
        this.ruleDocComments.put(string, string2);
    }

    public void addSampleSentence(String string, String string2) {
        JSGFRuleState jSGFRuleState = this.rules.get(string);
        if (jSGFRuleState == null) {
            return;
        }
        jSGFRuleState.samples.add(string2);
    }

    public void deleteRule(String string) throws IllegalArgumentException {
        this.rules.remove(this.getKnownRule((String)string).ruleName);
    }

    public String getGrammarDocComment() {
        return this.grammarDocComment;
    }

    public String getImportDocComment(JSGFRuleName jSGFRuleName) {
        return this.importDocComments.getProperty(jSGFRuleName.toString(), null);
    }

    public Collection<String> getJSGFTags(String string) {
        return this.ruleTags.get(string);
    }

    private JSGFRule getKnownRule(String string) {
        JSGFRuleState jSGFRuleState = this.rules.get(string);
        if (jSGFRuleState == null) {
            throw new IllegalArgumentException("Unknown Rule: " + string);
        }
        return jSGFRuleState.rule;
    }

    public String getName() {
        return this.name;
    }

    public JSGFRule getRule(String string) {
        JSGFRuleState jSGFRuleState = this.rules.get(string);
        if (jSGFRuleState == null) {
            return null;
        }
        return jSGFRuleState.rule;
    }

    public String getRuleDocComment(String string) {
        return this.ruleDocComments.getProperty(string, null);
    }

    public boolean isRulePublic(String string) throws IllegalArgumentException {
        JSGFRuleState jSGFRuleState = this.rules.get(string);
        if (jSGFRuleState == null) {
            return false;
        }
        return jSGFRuleState.isPublic;
    }

    public List<JSGFRuleName> getImports() {
        return this.imports;
    }

    public Set<String> getRuleNames() {
        return this.rules.keySet();
    }

    public void removeImport(JSGFRuleName jSGFRuleName) {
        if (this.imports.contains(jSGFRuleName)) {
            this.imports.remove(jSGFRuleName);
        }
    }

    public JSGFRuleName resolve(JSGFRuleName jSGFRuleName) throws JSGFGrammarException {
        Object object;
        Object object3;
        JSGFRuleName jSGFRuleName2 = new JSGFRuleName(jSGFRuleName.getRuleName());
        String string = jSGFRuleName2.getSimpleRuleName();
        String string2 = jSGFRuleName2.getSimpleGrammarName();
        String string3 = jSGFRuleName2.getPackageName();
        String string4 = jSGFRuleName2.getFullGrammarName();
        if (string3 != null && string2 == null) {
            throw new JSGFGrammarException("Error: badly formed rulename " + jSGFRuleName2);
        }
        if (jSGFRuleName.getSimpleRuleName().equals("NULL")) {
            return JSGFRuleName.NULL;
        }
        if (jSGFRuleName.getSimpleRuleName().equals("VOID")) {
            return JSGFRuleName.VOID;
        }
        if (string4 == null && this.getRule(string) != null) {
            return new JSGFRuleName(this.name + '.' + string);
        }
        if (string4 != null && (object3 = this.manager.retrieveGrammar(string4)) != null && ((JSGFRuleGrammar)object3).getRule(string) != null) {
            return new JSGFRuleName(string4 + '.' + string);
        }
        object3 = new ArrayList();
        ArrayList<JSGFRuleName> arrayList = new ArrayList<JSGFRuleName>(this.imports);
        arrayList.add(new JSGFRuleName(this.name + ".*"));
        for (JSGFRuleName object22 : arrayList) {
            object = object22.getSimpleRuleName();
            String string5 = object22.getSimpleGrammarName();
            String string6 = object22.getFullGrammarName();
            if (string6 == null) {
                throw new JSGFGrammarException("Error: badly formed import " + jSGFRuleName);
            }
            JSGFRuleGrammar jSGFRuleGrammar = this.manager.retrieveGrammar(string6);
            if (jSGFRuleGrammar == null) {
                System.out.println("Warning: import of unknown grammar " + jSGFRuleName + " in " + this.name);
                continue;
            }
            if (!((String)object).equals("*") && jSGFRuleGrammar.getRule((String)object) == null) {
                System.out.println("Warning: import of undefined rule " + jSGFRuleName + " in " + this.name);
                continue;
            }
            if (string6.equals(string4) || string5.equals(string4)) {
                if (((String)object).equals("*")) {
                    if (jSGFRuleGrammar.getRule(string) == null) continue;
                    object3.add(new JSGFRuleName(string6 + '.' + string));
                    continue;
                }
                if (!((String)object).equals(string)) continue;
                object3.add(new JSGFRuleName(string6 + '.' + string));
                continue;
            }
            if (string4 != null) continue;
            if (((String)object).equals("*")) {
                if (jSGFRuleGrammar.getRule(string) == null) continue;
                object3.add(new JSGFRuleName(string6 + '.' + string));
                continue;
            }
            if (!((String)object).equals(string)) continue;
            object3.add(new JSGFRuleName(string6 + '.' + string));
        }
        switch (object3.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (JSGFRuleName)object3.get(0);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Warning: ambiguous reference ").append(jSGFRuleName2).append(" in ").append(this.name).append(" to ");
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (JSGFRuleName)iterator.next();
            stringBuilder.append(object).append(" and ");
        }
        stringBuilder.setLength(stringBuilder.length() - 5);
        throw new JSGFGrammarException(stringBuilder.toString());
    }

    public void resolveAllRules() throws JSGFGrammarException {
        StringBuilder stringBuilder = new StringBuilder();
        for (JSGFRuleName object : this.imports) {
            String string = object.getFullGrammarName();
            JSGFRuleGrammar jSGFRuleGrammar = this.manager.retrieveGrammar(string);
            if (jSGFRuleGrammar != null) continue;
            stringBuilder.append("Undefined grammar ").append(string).append(" imported in ").append(this.name).append('\n');
        }
        if (stringBuilder.length() > 0) {
            throw new JSGFGrammarException(stringBuilder.toString());
        }
        for (JSGFRuleState jSGFRuleState : this.rules.values()) {
            this.resolveRule(jSGFRuleState.rule);
        }
    }

    protected void resolveRule(JSGFRule jSGFRule) throws JSGFGrammarException {
        if (jSGFRule instanceof JSGFRuleToken) {
            return;
        }
        if (jSGFRule instanceof JSGFRuleAlternatives) {
            for (JSGFRule jSGFRule2 : ((JSGFRuleAlternatives)jSGFRule).getRules()) {
                this.resolveRule(jSGFRule2);
            }
            return;
        }
        if (jSGFRule instanceof JSGFRuleSequence) {
            for (JSGFRule jSGFRule3 : ((JSGFRuleSequence)jSGFRule).getRules()) {
                this.resolveRule(jSGFRule3);
            }
            return;
        }
        if (jSGFRule instanceof JSGFRuleCount) {
            this.resolveRule(((JSGFRuleCount)jSGFRule).getRule());
            return;
        }
        if (jSGFRule instanceof JSGFRuleTag) {
            JSGFRuleTag jSGFRuleTag = (JSGFRuleTag)jSGFRule;
            JSGFRule jSGFRule4 = jSGFRuleTag.getRule();
            String string = jSGFRule4.toString();
            Collection<String> collection = this.ruleTags.get(string);
            if (collection == null) {
                collection = new HashSet<String>();
                this.ruleTags.put(string, collection);
            }
            collection.add(jSGFRuleTag.getTag());
            this.resolveRule(jSGFRule4);
            return;
        }
        if (jSGFRule instanceof JSGFRuleName) {
            JSGFRuleName jSGFRuleName = (JSGFRuleName)jSGFRule;
            JSGFRuleName jSGFRuleName2 = this.resolve(jSGFRuleName);
            if (jSGFRuleName2 == null) {
                throw new JSGFGrammarException("Unresolvable rulename in grammar " + this.name + ": " + jSGFRuleName);
            }
            jSGFRuleName.resolvedRuleName = jSGFRuleName2.getRuleName();
            jSGFRuleName.setRuleName(jSGFRuleName2.getRuleName());
            return;
        }
        throw new JSGFGrammarException("Unknown rule type");
    }

    public void setEnabled(boolean bl) {
        for (JSGFRuleState jSGFRuleState : this.rules.values()) {
            jSGFRuleState.isEnabled = bl;
        }
    }

    public boolean isEnabled(String string) {
        JSGFRuleState jSGFRuleState = this.rules.get(string);
        if (jSGFRuleState != null) {
            return jSGFRuleState.isEnabled;
        }
        return false;
    }

    public void setEnabled(String string, boolean bl) throws IllegalArgumentException {
        JSGFRuleState jSGFRuleState = this.rules.get(string);
        if (jSGFRuleState.isEnabled != bl) {
            jSGFRuleState.isEnabled = bl;
        }
    }

    public void setRule(String string, JSGFRule jSGFRule, boolean bl) throws NullPointerException, IllegalArgumentException {
        JSGFRuleState jSGFRuleState = new JSGFRuleState(jSGFRule, true, bl);
        this.rules.put(string, jSGFRuleState);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#JSGF V1.0;").append(LINE_SEPARATOR);
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append(this.formatComment(this.grammarDocComment));
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append("grammar ").append(this.name).append(';').append(LINE_SEPARATOR);
        stringBuilder.append(LINE_SEPARATOR);
        Set<Object> set = this.importDocComments.keySet();
        for (int i = 0; i < this.imports.size(); ++i) {
            String object = '<' + this.imports.get(i).getRuleName() + '>';
            if (!set.contains(object)) continue;
            stringBuilder.append(this.formatComment((String)this.importDocComments.get(object)));
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append("import ").append(object + ';').append(LINE_SEPARATOR);
            stringBuilder.append(LINE_SEPARATOR);
        }
        set = this.ruleDocComments.keySet();
        for (Map.Entry<String, JSGFRuleState> entry : this.rules.entrySet()) {
            String string = entry.getKey();
            if (set.size() > 0 && set.contains(string)) {
                stringBuilder.append(this.formatComment((String)this.ruleDocComments.get(string))).append(LINE_SEPARATOR);
            }
            JSGFRuleState jSGFRuleState = entry.getValue();
            if (jSGFRuleState.isPublic) {
                stringBuilder.append("public ");
            }
            stringBuilder.append('<').append((Object)string).append("> = ").append(jSGFRuleState.rule).append(';').append(LINE_SEPARATOR);
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private String formatComment(String string) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (string == null) {
            return stringBuilder.toString();
        }
        if (Pattern.compile("[\\n\\r\\f]+").matcher(string).find()) {
            String[] stringArray = string.split('[' + LINE_SEPARATOR + "]+");
            stringBuilder.append("/**").append(LINE_SEPARATOR);
            stringBuilder.append("  *").append(stringArray[0]).append(LINE_SEPARATOR);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append("  *").append(stringArray[i]).append(LINE_SEPARATOR);
            }
            stringBuilder.append("  */");
            return stringBuilder.toString();
        }
        return "//" + string;
    }

    public void saveJSGF(URL uRL) throws URISyntaxException, IOException {
        PrintStream printStream = new PrintStream(new File(uRL.toURI()));
        printStream.print(this.toString());
        printStream.flush();
        printStream.close();
    }

    public boolean isRuleChanged(String string) {
        JSGFRuleState jSGFRuleState = this.rules.get(string);
        return jSGFRuleState.isChanged;
    }

    public void setRuleChanged(String string, boolean bl) {
        JSGFRuleState jSGFRuleState = this.rules.get(string);
        jSGFRuleState.isChanged = bl;
    }

    class JSGFRuleState {
        public boolean isPublic;
        public boolean isEnabled;
        public JSGFRule rule;
        public ArrayList<String> samples;
        public boolean isChanged;

        public JSGFRuleState(JSGFRule jSGFRule, boolean bl, boolean bl2) {
            this.rule = jSGFRule;
            this.isPublic = bl2;
            this.isEnabled = bl;
            this.samples = new ArrayList();
        }
    }
}

