/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf.rule;

import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import java.util.List;

public class JSGFRuleAlternatives
extends JSGFRule {
    protected List<JSGFRule> rules;
    protected List<Float> weights;

    public JSGFRuleAlternatives() {
    }

    public JSGFRuleAlternatives(List<JSGFRule> list) {
        this.setRules(list);
        this.weights = null;
    }

    public JSGFRuleAlternatives(List<JSGFRule> list, List<Float> list2) throws IllegalArgumentException {
        assert (list.size() == list2.size());
        this.setRules(list);
        this.setWeights(list2);
    }

    public void append(JSGFRule jSGFRule) {
        assert (jSGFRule != null);
        this.rules.add(jSGFRule);
        if (this.weights != null) {
            this.weights.add(Float.valueOf(1.0f));
        }
    }

    public List<JSGFRule> getRules() {
        return this.rules;
    }

    public List<Float> getWeights() {
        return this.weights;
    }

    public void setRules(List<JSGFRule> list) {
        if (this.weights != null && list.size() != this.weights.size()) {
            this.weights = null;
        }
        this.rules = list;
    }

    public void setWeights(List<Float> list) throws IllegalArgumentException {
        if (list == null || list.size() == 0) {
            this.weights = null;
            return;
        }
        if (list.size() != this.rules.size()) {
            throw new IllegalArgumentException("weights/rules array length mismatch");
        }
        float f = 0.0f;
        for (Float f2 : list) {
            if (Float.isNaN(f2.floatValue())) {
                throw new IllegalArgumentException("illegal weight value: NaN");
            }
            if (Float.isInfinite(f2.floatValue())) {
                throw new IllegalArgumentException("illegal weight value: infinite");
            }
            if ((double)f2.floatValue() < 0.0) {
                throw new IllegalArgumentException("illegal weight value: negative");
            }
            f += f2.floatValue();
        }
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("illegal weight values: all zero");
        }
        this.weights = list;
    }

    @Override
    public String toString() {
        if (this.rules == null || this.rules.size() == 0) {
            return "<VOID>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.rules.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(" | ");
            }
            if (this.weights != null) {
                stringBuilder.append("/" + this.weights.get(i) + "/ ");
            }
            JSGFRule jSGFRule = this.rules.get(i);
            if (this.rules.get(i) instanceof JSGFRuleAlternatives) {
                stringBuilder.append("( ").append(jSGFRule).append(" )");
                continue;
            }
            stringBuilder.append(jSGFRule);
        }
        return stringBuilder.toString();
    }
}

