/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf.rule;

import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import java.util.StringTokenizer;

public class JSGFRuleName
extends JSGFRule {
    protected String fullRuleName;
    protected String packageName;
    protected String simpleGrammarName;
    protected String simpleRuleName;
    public String resolvedRuleName;
    public static final JSGFRuleName NULL = new JSGFRuleName("NULL");
    public static final JSGFRuleName VOID = new JSGFRuleName("VOID");

    public JSGFRuleName() {
        this("NULL");
    }

    public JSGFRuleName(String string) {
        this.setRuleName(string);
    }

    public String getFullGrammarName() {
        if (this.packageName != null) {
            return this.packageName + "." + this.simpleGrammarName;
        }
        return this.simpleGrammarName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRuleName() {
        return this.fullRuleName;
    }

    public String getSimpleGrammarName() {
        return this.simpleGrammarName;
    }

    public String getSimpleRuleName() {
        return this.simpleRuleName;
    }

    public boolean isLegalRuleName() {
        return JSGFRuleName.isLegalRuleName(this.fullRuleName);
    }

    public static boolean isLegalRuleName(String string) {
        if (string == null) {
            return false;
        }
        if ((string = JSGFRuleName.stripRuleName(string)).endsWith(".*")) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.length() == 0) {
            return false;
        }
        if (string.startsWith(".") || string.endsWith(".") || string.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.length();
            if (n == 0) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (JSGFRuleName.isRuleNamePart(string2.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isRuleNamePart(char c) {
        if (Character.isJavaIdentifierPart(c)) {
            return true;
        }
        return c == '!' || c == '#' || c == '%' || c == '&' || c == '(' || c == ')' || c == '+' || c == ',' || c == '-' || c == '/' || c == ':' || c == ';' || c == '=' || c == '@' || c == '[' || c == '\\' || c == ']' || c == '^' || c == '|' || c == '~';
    }

    public void setRuleName(String string) {
        String string2;
        this.fullRuleName = string2 = JSGFRuleName.stripRuleName(string);
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            this.packageName = null;
            this.simpleGrammarName = null;
            this.simpleRuleName = string2;
        } else {
            int n2 = string2.lastIndexOf(46, n - 1);
            if (n2 < 0) {
                this.packageName = null;
                this.simpleGrammarName = string2.substring(0, n);
                this.simpleRuleName = string2.substring(n + 1);
            } else {
                this.packageName = string2.substring(0, n2);
                this.simpleGrammarName = string2.substring(n2 + 1, n);
                this.simpleRuleName = string2.substring(n + 1);
            }
        }
    }

    public static String stripRuleName(String string) {
        if (string.startsWith("<") && string.endsWith(">")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public String toString() {
        return "<" + this.fullRuleName + ">";
    }
}

