/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class WordSequence
implements Comparable<WordSequence> {
    public static final Comparator<WordSequence> OLDEST_COMPARATOR = new Comparator<WordSequence>(){

        @Override
        public int compare(WordSequence wordSequence, WordSequence wordSequence2) {
            return wordSequence.getOldest().compareTo(wordSequence2.getOldest());
        }
    };
    public static final WordSequence EMPTY = new WordSequence(0);
    private final Word[] words;
    private transient int hashCode = -1;

    public static WordSequence asWordSequence(Dictionary dictionary, String ... stringArray) {
        Word[] wordArray = new Word[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            wordArray[i] = dictionary.getWord(stringArray[i]);
        }
        return new WordSequence(wordArray);
    }

    private WordSequence(int n) {
        this.words = new Word[n];
    }

    public WordSequence(Word ... wordArray) {
        this(Arrays.asList(wordArray));
    }

    public WordSequence(List<Word> list) {
        this.words = list.toArray(new Word[list.size()]);
        this.check();
    }

    private void check() {
        for (Word word : this.words) {
            if (word != null) continue;
            throw new Error("WordSequence should not have null Words.");
        }
    }

    public WordSequence addWord(Word word, int n) {
        if (n <= 0) {
            return EMPTY;
        }
        int n2 = this.size() + 1 > n ? n : this.size() + 1;
        WordSequence wordSequence = new WordSequence(n2);
        int n3 = n2 - 1;
        int n4 = this.size() - 1;
        wordSequence.words[n3--] = word;
        while (n3 >= 0 && n4 >= 0) {
            wordSequence.words[n3--] = this.words[n4--];
        }
        wordSequence.check();
        return wordSequence;
    }

    public WordSequence getOldest() {
        WordSequence wordSequence = EMPTY;
        if (this.size() >= 1) {
            wordSequence = new WordSequence(this.words.length - 1);
            System.arraycopy(this.words, 0, wordSequence.words, 0, wordSequence.words.length);
        }
        return wordSequence;
    }

    public WordSequence getNewest() {
        WordSequence wordSequence = EMPTY;
        if (this.size() >= 1) {
            wordSequence = new WordSequence(this.words.length - 1);
            System.arraycopy(this.words, 1, wordSequence.words, 0, wordSequence.words.length);
        }
        return wordSequence;
    }

    public WordSequence trim(int n) {
        if (n <= 0 || this.size() == 0) {
            return EMPTY;
        }
        if (n == this.size()) {
            return this;
        }
        if (n > this.size()) {
            n = this.size();
        }
        WordSequence wordSequence = new WordSequence(n);
        int n2 = this.words.length - 1;
        int n3 = wordSequence.words.length - 1;
        for (int i = 0; i < n; ++i) {
            wordSequence.words[n3--] = this.words[n2--];
        }
        return wordSequence;
    }

    public Word getWord(int n) {
        assert (n < this.words.length);
        return this.words[n];
    }

    public int size() {
        return this.words.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Word word : this.words) {
            stringBuilder.append('[').append(word).append(']');
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int n = 123;
            for (int i = 0; i < this.words.length; ++i) {
                n += this.words[i].hashCode() * (2 * i + 1);
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WordSequence)) {
            return false;
        }
        return Arrays.equals(this.words, ((WordSequence)object).words);
    }

    public WordSequence getSubSequence(int n, int n2) {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.getWord(i));
        }
        return new WordSequence(arrayList);
    }

    public Word[] getWords() {
        return this.getSubSequence((int)0, (int)this.size()).words;
    }

    @Override
    public int compareTo(WordSequence wordSequence) {
        int n = Math.min(this.words.length, wordSequence.words.length);
        for (int i = 0; i < n; ++i) {
            if (this.words[i].equals(wordSequence.words[i])) continue;
            return this.words[i].compareTo(wordSequence.words[i]);
        }
        return this.words.length - wordSequence.words.length;
    }
}

