/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.util.TimerPool;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HMMPool {
    private AcousticModel model;
    private Unit[] unitTable;
    private Map<HMMPosition, HMM[]> hmmTable;
    private int numCIUnits;
    private Logger logger;
    private UnitManager unitManager;
    static final HMMPosition[] pos = new HMMPosition[]{HMMPosition.BEGIN, HMMPosition.END, HMMPosition.SINGLE, HMMPosition.INTERNAL};
    static final int[] ids = new int[]{9206, 9320, 9620, 9865, 14831, 15836};

    protected HMMPool() {
    }

    public HMMPool(AcousticModel acousticModel, Logger logger, UnitManager unitManager) {
        Object object;
        this.logger = logger;
        int n = 0;
        this.model = acousticModel;
        this.unitManager = unitManager;
        if (acousticModel.getLeftContextSize() != 1) {
            throw new Error("LexTreeLinguist: Unsupported left context size");
        }
        if (acousticModel.getRightContextSize() != 1) {
            throw new Error("LexTreeLinguist: Unsupported right context size");
        }
        Iterator<Object> iterator = acousticModel.getContextIndependentUnitIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            logger.fine("CI unit " + object);
            if (((Unit)object).getBaseID() <= n) continue;
            n = ((Unit)object).getBaseID();
        }
        this.numCIUnits = n + 1;
        this.unitTable = new Unit[this.numCIUnits * this.numCIUnits * this.numCIUnits];
        iterator = acousticModel.getHMMIterator();
        while (iterator.hasNext()) {
            object = (HMM)iterator.next();
            Unit unit = object.getUnit();
            int n2 = this.getID(unit);
            this.unitTable[n2] = unit;
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("Unit " + unit + " id " + n2);
        }
        this.hmmTable = new EnumMap<HMMPosition, HMM[]>(HMMPosition.class);
        for (Iterator<Object> iterator2 : HMMPosition.values()) {
            HMM[] hMMArray = new HMM[this.unitTable.length];
            this.hmmTable.put((HMMPosition)((Object)iterator2), hMMArray);
            for (int i = 1; i < this.unitTable.length; ++i) {
                Unit unit = this.unitTable[i];
                if (unit == null) {
                    unit = this.synthesizeUnit(i);
                }
                if (unit == null) continue;
                hMMArray[i] = acousticModel.lookupNearestHMM(unit, (HMMPosition)((Object)iterator2), false);
                assert (hMMArray[i] != null);
            }
        }
    }

    public AcousticModel getModel() {
        return this.model;
    }

    private Unit synthesizeUnit(int n) {
        int n2 = this.getCentralUnitID(n);
        int n3 = this.getLeftUnitID(n);
        int n4 = this.getRightUnitID(n);
        if (n2 == 0 || n3 == 0 || n4 == 0) {
            return null;
        }
        Unit unit = this.unitTable[n2];
        Unit unit2 = this.unitTable[n3];
        Unit unit3 = this.unitTable[n4];
        assert (unit != null);
        assert (unit2 != null);
        assert (unit3 != null);
        Unit[] unitArray = new Unit[1];
        Unit[] unitArray2 = new Unit[1];
        unitArray[0] = unit2;
        unitArray2[0] = unit3;
        LeftRightContext leftRightContext = LeftRightContext.get(unitArray, unitArray2);
        Unit unit4 = this.unitManager.getUnit(unit.getName(), unit.isFiller(), leftRightContext);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Missing " + this.getUnitNameFromID(n) + " returning " + unit4);
        }
        return unit4;
    }

    public int getNumCIUnits() {
        return this.numCIUnits;
    }

    public Unit getUnit(int n) {
        return this.unitTable[n];
    }

    public HMM getHMM(int n, HMMPosition hMMPosition) {
        return this.hmmTable.get((Object)hMMPosition)[n];
    }

    public int getID(Unit unit) {
        if (unit.isContextDependent()) {
            LeftRightContext leftRightContext = (LeftRightContext)unit.getContext();
            assert (leftRightContext.getLeftContext().length == 1);
            assert (leftRightContext.getRightContext().length == 1);
            return this.buildID(this.getSimpleUnitID(unit), this.getSimpleUnitID(leftRightContext.getLeftContext()[0]), this.getSimpleUnitID(leftRightContext.getRightContext()[0]));
        }
        return this.getSimpleUnitID(unit);
    }

    private int getSimpleUnitID(Unit unit) {
        return unit.getBaseID();
    }

    public boolean isValidID(int n) {
        return n >= 0 && n < this.unitTable.length && this.unitTable[n] != null;
    }

    public int buildID(int n, int n2, int n3) {
        if (this.unitTable[n] == null) {
            return -1;
        }
        int n4 = this.unitTable[n].isFiller() ? n : n * (this.numCIUnits * this.numCIUnits) + n2 * this.numCIUnits + n3;
        assert (n4 < this.unitTable.length);
        return n4;
    }

    private int getLeftUnitID(int n) {
        return n / this.numCIUnits % this.numCIUnits;
    }

    private int getRightUnitID(int n) {
        return n % this.numCIUnits;
    }

    private int getCentralUnitID(int n) {
        return n / (this.numCIUnits * this.numCIUnits);
    }

    private String getUnitNameFromID(int n) {
        int n2 = this.getCentralUnitID(n);
        int n3 = this.getLeftUnitID(n);
        int n4 = this.getRightUnitID(n);
        String string = this.unitTable[n2] == null ? "(" + n2 + ')' : this.unitTable[n2].toString();
        String string2 = this.unitTable[n3] == null ? "(" + n3 + ')' : this.unitTable[n3].toString();
        String string3 = this.unitTable[n4] == null ? "(" + n4 + ')' : this.unitTable[n4].toString();
        return string + '[' + string2 + ',' + string3 + ']';
    }

    public HMM getHMM(Unit unit, Unit unit2, Unit unit3, HMMPosition hMMPosition) {
        int n = -1;
        int n2 = this.getID(unit);
        int n3 = this.getID(unit2);
        int n4 = this.getID(unit3);
        if (!this.isValidID(n2)) {
            this.logger.severe("Bad HMM Unit: " + unit.getName());
            return null;
        }
        if (!this.isValidID(n3)) {
            this.logger.severe("Bad HMM Unit: " + unit2.getName());
            return null;
        }
        if (!this.isValidID(n4)) {
            this.logger.severe("Bad HMM Unit: " + unit3.getName());
            return null;
        }
        n = this.buildID(n2, n3, n4);
        if (n < 0) {
            this.logger.severe("Unable to build HMM Unit ID for " + unit.getName() + " lc=" + unit2.getName() + " rc=" + unit3.getName());
            return null;
        }
        HMM hMM = this.getHMM(n, hMMPosition);
        if (hMM == null) {
            this.logger.severe("Missing HMM Unit for " + unit.getName() + " lc=" + unit2.getName() + " rc=" + unit3.getName());
        }
        return hMM;
    }

    public void dumpInfo() {
        this.logger.info("Max CI Units " + this.numCIUnits);
        this.logger.info("Unit table size " + this.unitTable.length);
        if (this.logger.isLoggable(Level.FINER)) {
            for (int i = 0; i < this.unitTable.length; ++i) {
                this.logger.finer(String.valueOf(i) + ' ' + this.unitTable[i]);
            }
        }
    }

    void benchmark() {
        int n = 0;
        System.out.println("benchmarking ...");
        TimerPool.getTimer(this, "hmmPoolBenchmark").start();
        for (int i = 0; i < 1000000; ++i) {
            int n2 = ids[i % ids.length];
            HMMPosition hMMPosition = pos[i % pos.length];
            HMM hMM = this.getHMM(n2, hMMPosition);
            if (hMM != null) continue;
            ++n;
        }
        TimerPool.getTimer(this, "hmmPoolBenchmark").stop();
        System.out.println("null count " + n);
    }
}

