/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

public enum HMMPosition {
    BEGIN('b'),
    END('e'),
    SINGLE('s'),
    INTERNAL('i'),
    UNDEFINED('-');

    private static final HMMPosition[] posByRep;
    private final String rep;

    private HMMPosition(char c) {
        this.rep = String.valueOf(c);
    }

    public static HMMPosition lookup(String string) {
        return string == null || string.isEmpty() ? null : posByRep[string.charAt(0)];
    }

    public boolean isWordEnd() {
        return this == SINGLE || this == END;
    }

    public boolean isWordBeginning() {
        return this == SINGLE || this == BEGIN;
    }

    public String toString() {
        return this.rep;
    }

    static {
        char c = '\u0000';
        for (HMMPosition hMMPosition : HMMPosition.values()) {
            if (hMMPosition.rep.charAt(0) <= c) continue;
            c = hMMPosition.rep.charAt(0);
        }
        posByRep = new HMMPosition[c + 1];
        HMMPosition[] hMMPositionArray = HMMPosition.values();
        int n = hMMPositionArray.length;
        for (int i = 0; i < n; ++i) {
            HMMPosition hMMPosition;
            HMMPosition.posByRep[hMMPosition.rep.charAt((int)0)] = hMMPosition = hMMPositionArray[i];
        }
    }
}

