/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;

public class LeftRightContext
extends Context {
    String stringRepresentation;
    final Unit[] leftContext;
    final Unit[] rightContext;

    private LeftRightContext(Unit[] unitArray, Unit[] unitArray2) {
        this.leftContext = unitArray;
        this.rightContext = unitArray2;
    }

    @Override
    public String toString() {
        return LeftRightContext.getContextName(this.leftContext) + ',' + LeftRightContext.getContextName(this.rightContext);
    }

    public static LeftRightContext get(Unit[] unitArray, Unit[] unitArray2) {
        return new LeftRightContext(unitArray, unitArray2);
    }

    public Unit[] getLeftContext() {
        return this.leftContext;
    }

    public Unit[] getRightContext() {
        return this.rightContext;
    }

    public static String getContextName(Unit[] unitArray) {
        if (unitArray == null) {
            return "*";
        }
        if (unitArray.length == 0) {
            return "(empty)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Unit unit : unitArray) {
            stringBuilder.append(unit == null ? null : unit.getName()).append('.');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    @Override
    public boolean isPartialMatch(Context context) {
        if (context instanceof LeftRightContext) {
            LeftRightContext leftRightContext = (LeftRightContext)context;
            Unit[] unitArray = leftRightContext.getLeftContext();
            Unit[] unitArray2 = leftRightContext.getRightContext();
            return !(unitArray != null && this.leftContext != null && !Unit.isContextMatch(unitArray, this.leftContext) || unitArray2 != null && this.rightContext != null && !Unit.isContextMatch(unitArray2, this.rightContext));
        }
        return context == Context.EMPTY_CONTEXT && this.leftContext == null && this.rightContext == null;
    }
}

