/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import java.util.Arrays;

public class Unit {
    public static final Unit[] EMPTY_ARRAY = new Unit[0];
    private final String name;
    private final boolean filler;
    private final boolean silence;
    private final int baseID;
    private final Unit baseUnit;
    private final Context context;
    private volatile String key;

    Unit(String string, boolean bl, int n) {
        this.name = string;
        this.filler = bl;
        this.silence = string.equals("SIL");
        this.baseID = n;
        this.baseUnit = this;
        this.context = Context.EMPTY_CONTEXT;
    }

    Unit(Unit unit, boolean bl, Context context) {
        this.name = unit.getName();
        this.filler = bl;
        this.silence = this.name.equals("SIL");
        this.baseID = unit.getBaseID();
        this.baseUnit = unit;
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFiller() {
        return this.filler;
    }

    public boolean isSilence() {
        return this.silence;
    }

    public int getBaseID() {
        return this.baseID;
    }

    public Unit getBaseUnit() {
        return this.baseUnit;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isContextDependent() {
        return this.getContext() != Context.EMPTY_CONTEXT;
    }

    private String getKey() {
        return this.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Unit) {
            Unit unit = (Unit)object;
            return this.getKey().equals(unit.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.context == Context.EMPTY_CONTEXT ? (this.filler ? "*" : "") + this.name : (this.filler ? "*" : "") + this.name + '[' + this.context + ']';
        }
        return this.key;
    }

    public boolean isPartialMatch(String string, Context context) {
        return this.getName().equals(string) && context.isPartialMatch(this.context);
    }

    public static Unit[] getEmptyContext(int n) {
        Object[] objectArray = new Unit[n];
        Arrays.fill(objectArray, UnitManager.SILENCE);
        return objectArray;
    }

    public static boolean isContextMatch(Unit[] unitArray, Unit[] unitArray2) {
        if (unitArray == null || unitArray2 == null) {
            return unitArray == unitArray2;
        }
        if (unitArray.length != unitArray2.length) {
            return false;
        }
        for (int i = 0; i < unitArray.length; ++i) {
            if (unitArray[i].getName().equals(unitArray2[i].getName())) continue;
            return false;
        }
        return true;
    }
}

