/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnitManager
implements Configurable {
    public static final String SILENCE_NAME = "SIL";
    private static final int SILENCE_ID = 1;
    public static final Unit SILENCE = new Unit("SIL", true, 1);
    private final Map<String, Unit> ciMap = new HashMap<String, Unit>();
    private int nextID;
    private Logger logger;

    public UnitManager() {
        this.ciMap.put(SILENCE_NAME, SILENCE);
        this.nextID = 2;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
    }

    public Unit getUnit(String string, boolean bl, Context context) {
        Unit unit = this.ciMap.get(string);
        if (context == Context.EMPTY_CONTEXT) {
            if (unit == null) {
                unit = new Unit(string, bl, this.nextID++);
                this.ciMap.put(string, unit);
                if (this.logger != null && this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("CI Unit: " + unit);
                }
            }
        } else {
            unit = new Unit(unit, bl, context);
        }
        return unit;
    }

    public Unit getUnit(String string, boolean bl) {
        return this.getUnit(string, bl, Context.EMPTY_CONTEXT);
    }

    public Unit getUnit(String string) {
        return this.getUnit(string, false, Context.EMPTY_CONTEXT);
    }
}

