/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.ScoreCachingSenone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.util.LogMath;

public class GaussianMixture
extends ScoreCachingSenone {
    protected GaussianWeights mixtureWeights;
    private MixtureComponent[] mixtureComponents;
    protected int id;
    protected LogMath logMath = LogMath.getLogMath();

    public GaussianMixture(GaussianWeights gaussianWeights, MixtureComponent[] mixtureComponentArray, int n) {
        this.mixtureComponents = mixtureComponentArray;
        this.mixtureWeights = gaussianWeights;
        this.id = n;
    }

    @Override
    public void dump(String string) {
        System.out.println(string + " GaussianMixture: ID " + this.getID());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Senone)) {
            return false;
        }
        Senone senone = (Senone)object;
        return this.getID() == senone.getID();
    }

    public int hashCode() {
        long l = this.getID();
        int n = (int)(l >> 32);
        int n2 = (int)l;
        return n + n2;
    }

    @Override
    public long getID() {
        return this.id;
    }

    public String toString() {
        return "senone id: " + this.getID();
    }

    @Override
    public float calculateScore(Data data) {
        if (data instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        float[] fArray = FloatData.toFloatData(data).getValues();
        float f = -3.4028235E38f;
        for (int i = 0; i < this.mixtureComponents.length; ++i) {
            f = this.logMath.addAsLinear(f, this.mixtureComponents[i].getScore(fArray) + this.mixtureWeights.get(this.id, 0, i));
        }
        return f;
    }

    @Override
    public float[] calculateComponentScore(Data data) {
        if (data instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        float[] fArray = FloatData.toFloatData(data).getValues();
        float[] fArray2 = new float[this.mixtureComponents.length];
        for (int i = 0; i < this.mixtureComponents.length; ++i) {
            fArray2[i] = this.mixtureComponents[i].getScore(fArray) + this.mixtureWeights.get(this.id, 0, i);
        }
        return fArray2;
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return this.mixtureComponents;
    }

    public int dimension() {
        return this.mixtureComponents[0].getMean().length;
    }

    public int numComponents() {
        return this.mixtureComponents.length;
    }

    @Override
    public float[] getLogMixtureWeights() {
        float[] fArray = new float[this.getMixtureComponents().length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.mixtureWeights.get(this.id, 0, i);
        }
        return fArray;
    }

    public float[] getComponentWeights() {
        float[] fArray = new float[this.getMixtureComponents().length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)this.logMath.logToLinear(this.mixtureWeights.get(this.id, 0, i));
        }
        return fArray;
    }

    public float getLogComponentWeight(int n) {
        return this.mixtureWeights.get(this.id, 0, n);
    }
}

