/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import java.util.logging.Logger;

public class GaussianWeights {
    private final float[][] weights;
    private final int numStates;
    private final int gauPerState;
    private final int numStreams;
    private final String name;

    public GaussianWeights(String string, int n, int n2, int n3) {
        this.numStates = n;
        this.gauPerState = n2;
        this.numStreams = n3;
        this.name = string;
        this.weights = new float[n2][n * n3];
    }

    public void put(int n, int n2, float[] fArray) {
        assert (fArray.length == this.gauPerState);
        for (int i = 0; i < this.gauPerState; ++i) {
            this.weights[i][n * this.numStreams + n2] = fArray[i];
        }
    }

    public float get(int n, int n2, int n3) {
        return this.weights[n3][n * this.numStreams + n2];
    }

    public int getStatesNum() {
        return this.numStates;
    }

    public int getGauPerState() {
        return this.gauPerState;
    }

    public int getStreamsNum() {
        return this.numStreams;
    }

    public String getName() {
        return this.name;
    }

    public void logInfo(Logger logger) {
        logger.info("Gaussian weights: " + this.name + ". Entries: " + this.numStates * this.numStreams);
    }

    public Pool<float[]> convertToPool() {
        return null;
    }
}

