/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class HMMManager
implements Iterable<HMM> {
    private final List<HMM> allHMMs = new ArrayList<HMM>();
    private final Map<HMMPosition, Map<Unit, HMM>> hmmsPerPosition = new EnumMap<HMMPosition, Map<Unit, HMM>>(HMMPosition.class);

    public HMMManager() {
        for (HMMPosition hMMPosition : HMMPosition.values()) {
            this.hmmsPerPosition.put(hMMPosition, new HashMap());
        }
    }

    public void put(HMM hMM) {
        this.hmmsPerPosition.get((Object)hMM.getPosition()).put(hMM.getUnit(), hMM);
        this.allHMMs.add(hMM);
    }

    public HMM get(HMMPosition hMMPosition, Unit unit) {
        return this.hmmsPerPosition.get((Object)hMMPosition).get(unit);
    }

    @Override
    public Iterator<HMM> iterator() {
        return this.allHMMs.iterator();
    }

    private int getNumHMMs() {
        int n = 0;
        for (Map<Unit, HMM> map : this.hmmsPerPosition.values()) {
            if (map == null) continue;
            n += map.size();
        }
        return n;
    }

    public void logInfo(Logger logger) {
        logger.info("HMM Manager: " + this.getNumHMMs() + " hmms");
    }
}

