/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.GMMDiag;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.HMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.Lab;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.SingleHMM;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HMMSet {
    private GMMDiag g;
    private int nGaussians;
    float[][] trans;
    public final List<HMMState> states;
    public final List<float[][]> transitions = new ArrayList<float[][]>();
    public final Map<String, Integer> transNames = new HashMap<String, Integer>();
    public final List<GMMDiag> gmms;
    public final List<SingleHMM> hmms;
    private String[][] tiedHMMs;

    public Iterator<SingleHMM> get1phIt() {
        Iterator<SingleHMM> iterator = new Iterator<SingleHMM>(){
            int cur;

            @Override
            public void remove() {
            }

            @Override
            public SingleHMM next() {
                SingleHMM singleHMM;
                do {
                    if (this.cur < HMMSet.this.hmms.size()) continue;
                    return null;
                } while ((singleHMM = HMMSet.this.hmms.get(this.cur++)).getName().indexOf(45) >= 0 || singleHMM.getName().indexOf(43) >= 0);
                return singleHMM;
            }

            @Override
            public boolean hasNext() {
                return false;
            }
        };
        return iterator;
    }

    public Iterator<SingleHMM> get3phIt() {
        Iterator<SingleHMM> iterator = new Iterator<SingleHMM>(){
            int cur;

            @Override
            public void remove() {
            }

            @Override
            public SingleHMM next() {
                SingleHMM singleHMM;
                do {
                    if (this.cur < HMMSet.this.hmms.size()) continue;
                    return null;
                } while ((singleHMM = HMMSet.this.hmms.get(this.cur++)).getName().indexOf(45) < 0 && singleHMM.getName().indexOf(43) < 0);
                return singleHMM;
            }

            @Override
            public boolean hasNext() {
                return false;
            }
        };
        return iterator;
    }

    public int getStateIdx(HMMState hMMState) {
        return hMMState.gmmidx;
    }

    public int getHMMidx(SingleHMM singleHMM) {
        for (int i = 0; i < this.hmms.size(); ++i) {
            SingleHMM singleHMM2 = this.hmms.get(i);
            if (singleHMM2 != singleHMM) continue;
            return i;
        }
        return -1;
    }

    public int getNstates() {
        return this.gmms.size();
    }

    public String[] getHMMnames() {
        String[] stringArray = new String[this.hmms.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            SingleHMM singleHMM = this.hmms.get(i);
            stringArray[i] = singleHMM.getName();
        }
        return stringArray;
    }

    public int getNhmms() {
        return this.hmms.size();
    }

    public int getNhmmsMono() {
        int n = 0;
        for (SingleHMM singleHMM : this.hmms) {
            if (singleHMM.getName().indexOf(45) >= 0 || singleHMM.getName().indexOf(43) >= 0) continue;
            ++n;
        }
        return n;
    }

    public int getNhmmsTri() {
        int n = 0;
        for (SingleHMM singleHMM : this.hmms) {
            if (singleHMM.getName().indexOf(45) < 0 && singleHMM.getName().indexOf(43) < 0) continue;
            ++n;
        }
        return n;
    }

    public int getHMMIndex(SingleHMM singleHMM) {
        return this.hmms.indexOf(singleHMM);
    }

    public int getStateIdx(int n, int n2) {
        SingleHMM singleHMM;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            singleHMM = this.hmms.get(n3);
            n4 += singleHMM.getNbEmittingStates();
        }
        singleHMM = this.hmms.get(n);
        for (n3 = 1; n3 < n2; ++n3) {
            if (!singleHMM.isEmitting(n3)) continue;
            ++n4;
        }
        if (singleHMM.isEmitting(n2)) {
            return n4;
        }
        return -1;
    }

    public SingleHMM getHMM(int n) {
        return this.hmms.get(n);
    }

    public SingleHMM getHMM(String string) {
        SingleHMM singleHMM;
        SingleHMM singleHMM2 = null;
        Iterator<SingleHMM> iterator = this.hmms.iterator();
        while (iterator.hasNext() && !(singleHMM2 = (singleHMM = iterator.next())).getName().equals(string)) {
        }
        return singleHMM2;
    }

    public HMMSet() {
        this.states = new ArrayList<HMMState>();
        this.hmms = new ArrayList<SingleHMM>();
        this.gmms = new ArrayList<GMMDiag>();
    }

    public void loadHTK(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                if (string2.startsWith("~s")) {
                    string3 = string2.substring(string2.indexOf(34) + 1, string2.lastIndexOf(34));
                    this.loadState(bufferedReader, string3, null);
                    continue;
                }
                if (string2.startsWith("~v")) continue;
                if (string2.startsWith("~t")) {
                    string3 = string2.substring(string2.indexOf(34) + 1, string2.lastIndexOf(34));
                    this.loadTrans(bufferedReader, string3, null);
                    continue;
                }
                if (!string2.startsWith("~h")) continue;
                string3 = string2.substring(string2.indexOf(34) + 1, string2.lastIndexOf(34));
                if (string3.toUpperCase().equals(string3)) {
                    System.out.println("WARNING: HMM is in lowercase, converting to upper");
                }
                this.hmms.add(this.loadHMM(bufferedReader, string3.toUpperCase(), this.gmms));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void loadTiedList(String string) {
        try {
            String[] stringArray;
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringArray = string2.split(" ");
                if (stringArray.length < 2) continue;
                ++n;
            }
            this.tiedHMMs = new String[n][2];
            bufferedReader.close();
            bufferedReader = new BufferedReader(new FileReader(string));
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringArray = string2.split(" ");
                if (stringArray.length < 2) continue;
                this.tiedHMMs[n2][0] = stringArray[0];
                this.tiedHMMs[n2++][1] = stringArray[1];
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private SingleHMM loadHMM(BufferedReader bufferedReader, String string, List<GMMDiag> list) throws IOException {
        GMMDiag gMMDiag = null;
        String string2 = string;
        String string3 = "";
        while (!string3.startsWith("<NUMSTATES>")) {
            string3 = bufferedReader.readLine();
        }
        int n = Integer.parseInt(string3.substring(string3.indexOf(32) + 1));
        SingleHMM singleHMM = new SingleHMM(--n);
        singleHMM.setName(string);
        singleHMM.hmmset = this;
        while (!string3.startsWith("<STATE>")) {
            string3 = bufferedReader.readLine();
        }
        while (string3.startsWith("<STATE>")) {
            Object object;
            int n2 = Integer.parseInt(string3.substring(string3.indexOf(32) + 1));
            --n2;
            string3 = bufferedReader.readLine();
            int n3 = -1;
            if (string3.startsWith("~s")) {
                int n4;
                object = string3.substring(string3.indexOf(34) + 1, string3.lastIndexOf(34));
                for (n4 = 0; n4 < list.size(); ++n4) {
                    gMMDiag = list.get(n4);
                    if (gMMDiag.nom.equals(object)) break;
                }
                n3 = n4;
                if (n4 == list.size()) {
                    System.err.println("Error creatiing HMM : state " + string2 + " not found");
                    System.exit(1);
                }
            } else {
                this.loadState(bufferedReader, "", string3);
                n3 = this.gmms.size() - 1;
                gMMDiag = this.gmms.get(this.gmms.size() - 1);
            }
            object = new HMMState(gMMDiag, new Lab(string2, n2));
            ((HMMState)object).gmmidx = n3;
            this.states.add((HMMState)object);
            singleHMM.setState(n2 - 1, (HMMState)object);
            string3 = bufferedReader.readLine();
            if (!string3.startsWith("<GCONST>")) continue;
            string3 = bufferedReader.readLine();
        }
        if (string3.startsWith("~t")) {
            String string4 = string3.substring(string3.indexOf(34) + 1, string3.lastIndexOf(34));
            int n5 = this.getTrans(string4);
            singleHMM.setTrans(n5);
        } else {
            if (!string3.startsWith("<TRANSP>")) {
                System.err.println("Error reading model: missing transitions." + string3);
                System.exit(1);
            }
            this.loadTrans(bufferedReader, null, string3);
            singleHMM.setTrans(this.trans);
        }
        string3 = bufferedReader.readLine();
        if (!string3.startsWith("<ENDHMM>")) {
            System.err.println("Error reading model: missing ENDHMM." + string3);
            System.exit(1);
        }
        return singleHMM;
    }

    private int loadTrans(BufferedReader bufferedReader, String string, String string2) throws IOException {
        int n;
        int n2 = 0;
        String string3 = string2 != null ? string2 : bufferedReader.readLine().trim();
        if (string3.startsWith("<TRANSP>")) {
            n2 = Integer.parseInt(string3.substring(string3.indexOf(32) + 1));
            --n2;
        } else {
            System.err.println("ERROR no TRANSP !");
            System.exit(1);
        }
        this.trans = new float[n2][n2];
        bufferedReader.readLine();
        for (n = 0; n < n2; ++n) {
            string3 = bufferedReader.readLine().trim();
            String[] stringArray = string3.split(" ");
            for (int i = 0; i < n2; ++i) {
                this.trans[n][i] = Float.parseFloat(stringArray[i + 1]);
            }
        }
        if (string != null) {
            n = this.transitions.size();
            this.transNames.put(string, n);
            this.transitions.add(this.trans);
            return n;
        }
        return -1;
    }

    private int getTrans(String string) {
        int n = this.transNames.get(string);
        return n;
    }

    private void loadState(BufferedReader bufferedReader, String string, String string2) throws IOException {
        this.nGaussians = 1;
        String string3 = string2 != null ? string2 : bufferedReader.readLine().trim();
        if (string3.startsWith("<NUMMIXES>")) {
            this.nGaussians = Integer.parseInt(string3.substring(string3.indexOf(32) + 1));
            string3 = bufferedReader.readLine().trim();
        }
        this.g = null;
        if (!string3.startsWith("<MIXTURE>")) {
            if (this.nGaussians != 1) {
                System.err.println("Error loading model: number of mixtures is " + this.nGaussians + " while state " + string3 + " has 1 mixture.");
                System.exit(1);
            }
            this.loadHTKGauss(bufferedReader, 0, string3);
            this.g.setWeight(0, 1.0f);
        } else {
            for (int i = 0; i < this.nGaussians; ++i) {
                String[] stringArray;
                if (i > 0) {
                    string3 = bufferedReader.readLine().trim();
                }
                if (string3.startsWith("<GCONST>")) {
                    string3 = bufferedReader.readLine().trim();
                }
                if (Integer.parseInt((stringArray = string3.split(" "))[1]) != i + 1) {
                    System.err.println("Error reading model: mixture conflict " + i + ' ' + string3);
                    System.exit(1);
                }
                this.loadHTKGauss(bufferedReader, i, null);
                this.g.setWeight(i, Float.parseFloat(stringArray[2]));
            }
        }
        this.g.precomputeDistance();
        this.g.setNom(string);
        this.gmms.add(this.g);
    }

    private void loadHTKGauss(BufferedReader bufferedReader, int n, String string) throws IOException {
        int n2;
        String[] stringArray;
        String string2 = string != null ? string : bufferedReader.readLine().trim();
        if (string2.startsWith("<GCONST>")) {
            string2 = bufferedReader.readLine().trim();
        }
        if (string2.startsWith("<RCLASS>")) {
            string2 = bufferedReader.readLine().trim();
        }
        if (!string2.startsWith("<MEAN>")) {
            System.err.println("Error loading model: can't find <MEAN> ! " + string2);
            System.exit(1);
        }
        int n3 = Integer.parseInt(string2.substring(string2.indexOf(32) + 1));
        if (this.g == null) {
            this.g = new GMMDiag(this.nGaussians, n3);
        }
        if ((stringArray = (string2 = bufferedReader.readLine().trim()).split(" ")).length != n3) {
            System.err.println("Error loading model: incorrect number of coefficients " + n3 + ' ' + string2 + ' ' + stringArray[0] + ' ' + stringArray[39]);
            System.exit(1);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.g.setMean(n, n2, Float.parseFloat(stringArray[n2]));
        }
        string2 = bufferedReader.readLine().trim();
        if (!string2.startsWith("<VARIANCE>")) {
            System.err.println("Error loading model: missing <VARIANCE> ! " + string2);
            System.exit(1);
        }
        if ((stringArray = (string2 = bufferedReader.readLine().trim()).split(" ")).length != n3) {
            System.err.println("Error loading model: incorrect number of coefficients " + n3 + ' ' + string2);
            System.exit(1);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.g.setVar(n, n2, Float.parseFloat(stringArray[n2]));
        }
    }

    public GMMDiag findState(Lab lab) {
        while (true) {
            int n;
            HMMState hMMState = null;
            for (n = 0; n < this.states.size() && !(hMMState = this.states.get(n)).getLab().isEqual(lab); ++n) {
            }
            if (n < this.states.size()) {
                return hMMState.gmm;
            }
            if (this.tiedHMMs == null) break;
            for (n = 0; n < this.tiedHMMs.length && !this.tiedHMMs[n][0].equals(lab.getName()); ++n) {
            }
            if (n >= this.tiedHMMs.length) break;
            lab = new Lab(this.tiedHMMs[n][1], lab.getState());
        }
        System.err.println("WARNING: state is not found in hmmset " + lab);
        return null;
    }
}

