/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.StringTokenizer;

public class NamesConversion {
    final HashMap<String, String> phoneConv = new HashMap();
    final HashMap<String, String> wordConv = new HashMap();
    String left;
    String base;
    String right;

    void addInConv(String string, HashMap<String, String> hashMap) {
        if (!hashMap.containsKey(string)) {
            String string2 = string.toUpperCase();
            while (hashMap.containsValue(string2)) {
                string2 = string2 + "_X";
            }
            hashMap.put(string, string2);
        }
    }

    void buildPhoneConversion(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("~h");
                if (n < 0) continue;
                n = string2.indexOf(34);
                int n2 = string2.lastIndexOf(34);
                String string3 = string2.substring(n + 1, n2);
                this.split3ph(string3);
                if (this.left != null) {
                    this.addInConv(this.left, this.phoneConv);
                }
                if (this.base != null) {
                    this.addInConv(this.base, this.phoneConv);
                }
                if (this.right == null) continue;
                this.addInConv(this.right, this.phoneConv);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void buildWordConversion(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken();
                this.addInConv(string3, this.wordConv);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void split3ph(String string) {
        int n = string.indexOf(45);
        if (n >= 0) {
            this.left = string.substring(0, n);
        } else {
            this.left = null;
            n = -1;
        }
        String string2 = string.substring(n + 1);
        n = string2.indexOf(43);
        if (n >= 0) {
            this.right = string2.substring(n + 1);
        } else {
            this.right = null;
            n = string2.length();
        }
        this.base = string2.substring(0, n);
    }

    String conv3ph() {
        String string = this.left != null ? this.conv1ph(this.left) + '-' : "";
        string = string + this.conv1ph(this.base);
        if (this.right != null) {
            string = string + '+' + this.conv1ph(this.right);
        }
        if (string.equals("null")) {
            System.err.println("detson error " + this.left + ' ' + this.base + ' ' + this.right);
            System.exit(1);
        }
        return string;
    }

    String conv1ph(String string) {
        return this.phoneConv.get(string);
    }

    void convertMMF(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".conv"));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("~h");
                if (n >= 0) {
                    n = string2.indexOf(34);
                    int n2 = string2.lastIndexOf(34);
                    String string3 = string2.substring(n + 1, n2);
                    this.split3ph(string3);
                    String string4 = this.conv3ph();
                    printWriter.println("~h \"" + string4 + '\"');
                    continue;
                }
                printWriter.println(string2);
            }
            printWriter.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void convertWordGrammar(String string) {
        try {
            String string2;
            String string3;
            StringTokenizer stringTokenizer;
            int n;
            String string4;
            int n2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".conv"));
            do {
                if ((string4 = bufferedReader.readLine()) == null) {
                    printWriter.close();
                    bufferedReader.close();
                    return;
                }
                printWriter.println(string4);
            } while ((n2 = string4.indexOf("\\data\\")) != 0);
            do {
                if ((string4 = bufferedReader.readLine()) == null) {
                    printWriter.close();
                    bufferedReader.close();
                    return;
                }
                printWriter.println(string4);
            } while ((n2 = string4.indexOf("\\1-grams:")) != 0);
            n2 = 0;
            while (n2 == 0) {
                string4 = bufferedReader.readLine();
                if (string4 == null) {
                    printWriter.close();
                    bufferedReader.close();
                    return;
                }
                n = string4.indexOf("\\2-grams:");
                if (n == 0) {
                    printWriter.println(string4);
                    break;
                }
                n = string4.indexOf("\\end\\");
                if (n == 0) {
                    n2 = 1;
                    printWriter.println(string4);
                    break;
                }
                stringTokenizer = new StringTokenizer(string4);
                if (!(stringTokenizer != null & stringTokenizer.hasMoreTokens())) continue;
                printWriter.print(stringTokenizer.nextToken() + ' ');
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    string2 = this.wordConv.get(string3);
                    if (string2 == null) {
                        System.err.println("WARNING word " + string3 + " not in lexicon !");
                        this.addInConv(string3, this.wordConv);
                        string2 = this.wordConv.get(string3);
                    }
                    printWriter.print(string2 + ' ');
                    while (stringTokenizer.hasMoreTokens()) {
                        printWriter.print(stringTokenizer.nextToken() + ' ');
                    }
                }
                printWriter.println();
            }
            while (n2 == 0) {
                string4 = bufferedReader.readLine();
                if (string4 == null) {
                    printWriter.close();
                    bufferedReader.close();
                    return;
                }
                n = string4.indexOf("\\3-grams:");
                if (n == 0) {
                    printWriter.println(string4);
                    break;
                }
                n = string4.indexOf("\\end\\");
                if (n == 0) {
                    n2 = 1;
                    printWriter.println(string4);
                    break;
                }
                stringTokenizer = new StringTokenizer(string4);
                if (!(stringTokenizer != null & stringTokenizer.hasMoreTokens())) continue;
                printWriter.print(stringTokenizer.nextToken() + ' ');
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    string2 = this.wordConv.get(string3);
                    if (string2 == null) {
                        string2 = string3;
                    }
                    printWriter.print(string2 + ' ');
                    if (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        string2 = this.wordConv.get(string3);
                        if (string2 == null) {
                            string2 = string3;
                        }
                        printWriter.print(string2 + ' ');
                        while (stringTokenizer.hasMoreTokens()) {
                            printWriter.print(stringTokenizer.nextToken() + ' ');
                        }
                    }
                }
                printWriter.println();
            }
            while (n2 == 0) {
                string4 = bufferedReader.readLine();
                if (string4 == null) {
                    printWriter.close();
                    bufferedReader.close();
                    return;
                }
                n = string4.indexOf("\\end\\");
                if (n == 0) {
                    n2 = 1;
                    printWriter.println(string4);
                    break;
                }
                stringTokenizer = new StringTokenizer(string4);
                if (!(stringTokenizer != null & stringTokenizer.hasMoreTokens())) continue;
                printWriter.print(stringTokenizer.nextToken() + ' ');
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    string2 = this.wordConv.get(string3);
                    if (string2 == null) {
                        string2 = string3;
                    }
                    printWriter.print(string2 + ' ');
                    if (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        string2 = this.wordConv.get(string3);
                        if (string2 == null) {
                            string2 = string3;
                        }
                        printWriter.print(string2 + ' ');
                        if (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            string2 = this.wordConv.get(string3);
                            if (string2 == null) {
                                string2 = string3;
                            }
                            printWriter.print(string2 + ' ');
                            while (stringTokenizer.hasMoreTokens()) {
                                printWriter.print(stringTokenizer.nextToken() + ' ');
                            }
                        }
                    }
                }
                printWriter.println();
            }
            printWriter.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void convertLexicon(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".conv"));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (stringTokenizer == null || !stringTokenizer.hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken();
                String string4 = this.wordConv.get(string3);
                if (string4 != null) {
                    string3 = string4;
                }
                printWriter.print(string3 + ' ');
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (string5.charAt(0) == '[') {
                        while (!string5.endsWith("]")) {
                            string5 = stringTokenizer.nextToken();
                        }
                        string5 = stringTokenizer.nextToken();
                    }
                    this.split3ph(string5);
                    String string6 = this.conv3ph();
                    printWriter.print(string6 + ' ');
                }
                printWriter.println();
            }
            printWriter.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-lex")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-gram")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-mmf")) {
                string = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-filler")) continue;
            string3 = stringArray[++i];
        }
        if (string != null) {
            NamesConversion namesConversion = new NamesConversion();
            namesConversion.buildPhoneConversion(string);
            namesConversion.buildWordConversion(string2);
            System.out.println("converting phones in MMF to " + string + ".conv");
            namesConversion.convertMMF(string);
            if (string2 != null) {
                System.out.println("converting phones and words in lexicon to " + string2 + ".conv");
                namesConversion.convertLexicon(string2);
            }
            if (string3 != null) {
                System.out.println("converting phones in filler to " + string3 + ".conv");
                namesConversion.convertLexicon(string3);
            }
            if (string4 != null) {
                System.out.println("converting words in gram to " + string4 + ".conv");
                namesConversion.convertWordGrammar(string4);
            }
        }
    }
}

