/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.GMMDiag;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.HMMSet;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.HMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.SingleHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTKLoader
implements Loader {
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4Boolean(defaultValue=true)
    public static final String PROP_IS_BINARY = "isBinary";
    @S4String(mandatory=true, defaultValue="hmmdefs")
    public static final String PROP_MODEL = "modelDefinition";
    @S4Boolean(defaultValue=true)
    public static final String PROP_TIE_1PH = "tie1ph";
    @S4String(defaultValue="model.props")
    public static final String PROP_PROPERTIES_FILE = "propertiesFile";
    @S4Integer(defaultValue=39)
    public static final String PROP_VECTOR_LENGTH = "vectorLength";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "MixtureComponentScoreFloor";
    @S4Double(defaultValue=9.999999747378752E-5)
    public static final String PROP_VARIANCE_FLOOR = "varianceFloor";
    @S4Double(defaultValue=1.0000000116860974E-7)
    public static final String PROP_MW_FLOOR = "mixtureWeightFloor";
    protected static final String FILLER = "filler";
    protected static final String SILENCE_CIPHONE = "SIL";
    protected static final int BYTE_ORDER_MAGIC = 287454020;
    public static final String MODEL_VERSION = "0.3";
    protected static final int CONTEXT_SIZE = 1;
    private Pool<float[]> meansPool;
    private Pool<float[]> variancePool;
    private Pool<float[][]> matrixPool;
    private Pool<float[][]> meanTransformationMatrixPool;
    private Pool<float[]> meanTransformationVectorPool;
    private Pool<float[][]> varianceTransformationMatrixPool;
    private Pool<float[]> varianceTransformationVectorPool;
    private GaussianWeights mixtureWeights;
    private Pool<Senone> senonePool;
    private Map<String, Unit> contextIndependentUnits;
    private HMMManager hmmManager;
    private LogMath logMath;
    private UnitManager unitManager;
    private Properties properties;
    private boolean swap;
    protected static final String DENSITY_FILE_VERSION = "1.0";
    protected static final String MIXW_FILE_VERSION = "1.0";
    protected static final String TMAT_FILE_VERSION = "1.0";
    private String name;
    private Logger logger;
    private String location;
    private String model;
    private String dataDir;
    private String propsFile;
    private float distFloor;
    private float mixtureWeightFloor;
    private float varianceFloor;
    private boolean useCDUnits;
    private boolean loaded;
    private boolean tie1ph;

    public HTKLoader(String string, UnitManager unitManager, boolean bl, int n, String string2, boolean bl2, float f, float f2, float f3) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.propsFile = string;
        this.loadProperties();
        this.logMath = LogMath.getLogMath();
        this.unitManager = unitManager;
        this.model = string2;
        this.tie1ph = bl2;
        this.distFloor = f;
        this.mixtureWeightFloor = f2;
        this.varianceFloor = f3;
    }

    public HTKLoader() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.propsFile = propertySheet.getString(PROP_PROPERTIES_FILE);
        this.loadProperties();
        this.unitManager = (UnitManager)propertySheet.getComponent(PROP_UNIT_MANAGER);
        String string = (String)this.properties.get(PROP_MODEL);
        this.model = string != null ? string : propertySheet.getString(PROP_MODEL);
        this.tie1ph = propertySheet.getBoolean(PROP_TIE_1PH);
        this.distFloor = propertySheet.getFloat(PROP_MC_FLOOR);
        this.mixtureWeightFloor = propertySheet.getFloat(PROP_MW_FLOOR);
        this.varianceFloor = propertySheet.getFloat(PROP_VARIANCE_FLOOR);
    }

    private void loadProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                URL uRL = this.getClass().getResource(this.propsFile);
                if (uRL != null) {
                    this.properties.load(uRL.openStream());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void load() throws IOException {
        if (!this.loaded) {
            this.hmmManager = new HMMManager();
            this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
            this.meanTransformationMatrixPool = null;
            this.meanTransformationVectorPool = null;
            this.varianceTransformationMatrixPool = null;
            this.varianceTransformationVectorPool = null;
            this.loadModelFiles(this.model);
            System.err.println("HTK -> S4 conversion finished");
            this.loaded = true;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties;
    }

    protected String getLocation() {
        return this.location;
    }

    private void loadModelFiles(String string) throws IOException {
        this.logger.config("Loading HTK acoustic model: " + string);
        this.logger.config("    Path      : " + this.location);
        this.logger.config("    modellName: " + this.model);
        this.logger.config("    dataDir   : " + this.dataDir);
        HTKStruct hTKStruct = new HTKStruct();
        hTKStruct.load(string);
        this.meansPool = hTKStruct.htkMeans(string);
        this.variancePool = hTKStruct.htkVars(string, this.varianceFloor);
        this.mixtureWeights = hTKStruct.htkWeights(string, this.mixtureWeightFloor);
        this.matrixPool = hTKStruct.htkTrans(string);
        this.senonePool = this.createSenonePool(this.distFloor, this.varianceFloor);
        this.loadHMMPool(this.useCDUnits, hTKStruct, this.location + File.separator + this.model);
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    private Pool<Senone> createSenonePool(float f, float f2) {
        Pool<Senone> pool = new Pool<Senone>("senones");
        int n = this.meansPool.size();
        int n2 = this.variancePool.size();
        int n3 = this.mixtureWeights.getGauPerState();
        int n4 = this.mixtureWeights.getStatesNum();
        int n5 = 0;
        this.logger.fine("NG " + n3);
        this.logger.fine("NS " + n4);
        this.logger.fine("NMNS " + n);
        this.logger.fine("NMNS " + n2);
        assert (n3 > 0);
        assert (n2 == n4 * n3);
        assert (n == n4 * n3);
        float[][] fArray = this.meanTransformationMatrixPool == null ? (float[][])null : this.meanTransformationMatrixPool.get(0);
        float[] fArray2 = this.meanTransformationVectorPool == null ? null : this.meanTransformationVectorPool.get(0);
        float[][] fArray3 = this.varianceTransformationMatrixPool == null ? (float[][])null : this.varianceTransformationMatrixPool.get(0);
        float[] fArray4 = this.varianceTransformationVectorPool == null ? null : this.varianceTransformationVectorPool.get(0);
        for (int i = 0; i < n4; ++i) {
            MixtureComponent[] mixtureComponentArray = new MixtureComponent[n3];
            for (int j = 0; j < n3; ++j) {
                mixtureComponentArray[j] = new MixtureComponent(this.meansPool.get(n5), fArray, fArray2, this.variancePool.get(n5), fArray3, fArray4, f, f2);
                ++n5;
            }
            GaussianMixture gaussianMixture = new GaussianMixture(this.mixtureWeights, mixtureComponentArray, i);
            pool.put(i, gaussianMixture);
        }
        return pool;
    }

    String readWord(DataInputStream dataInputStream) throws IOException {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while (Character.isWhitespace(c = this.readChar(dataInputStream))) {
        }
        do {
            stringBuilder.append(c);
        } while (!Character.isWhitespace(c = this.readChar(dataInputStream)));
        return stringBuilder.toString();
    }

    private char readChar(DataInputStream dataInputStream) throws IOException {
        return (char)dataInputStream.readByte();
    }

    protected int readInt(DataInputStream dataInputStream) throws IOException {
        if (this.swap) {
            return Utilities.readLittleEndianInt(dataInputStream);
        }
        return dataInputStream.readInt();
    }

    protected float readFloat(DataInputStream dataInputStream) throws IOException {
        float f = this.swap ? Utilities.readLittleEndianFloat(dataInputStream) : dataInputStream.readFloat();
        return f;
    }

    protected float[] readFloatArray(DataInputStream dataInputStream, int n) throws IOException {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.readFloat(dataInputStream);
        }
        return fArray;
    }

    protected void loadHMMPool(boolean bl, HTKStruct hTKStruct, String string) throws IOException {
        SingleHMM singleHMM;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        int n2;
        int n3;
        Object object6;
        Object object7;
        SingleHMM singleHMM2;
        Object object8;
        if (!this.tie1ph) {
            object8 = hTKStruct.hmmsHTK.get1phIt();
            while (object8.hasNext() && (singleHMM2 = object8.next()) != null) {
                object7 = singleHMM2.getName();
                object6 = ((String)object7).equals("sil") || ((String)object7).equals("sp") || ((String)object7).equals("bb") || ((String)object7).equals("xx") || ((String)object7).equals("hh") ? FILLER : "nofiller";
                n3 = singleHMM2.trIdx;
                n2 = singleHMM2.getNstates();
                object5 = new int[singleHMM2.getNbEmittingStates()];
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!singleHMM2.isEmitting(i)) continue;
                    object4 = singleHMM2.getState(i);
                    object5[n] = hTKStruct.hmmsHTK.getStateIdx((HMMState)object4);
                    ++n;
                }
                object3 = this.unitManager.getUnit((String)object7, object6.equals(FILLER));
                this.contextIndependentUnits.put(((Unit)object3).getName(), (Unit)object3);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Loaded " + object3);
                }
                if (((Unit)object3).isFiller() && ((Unit)object3).getName().equals(SILENCE_CIPHONE)) {
                    object3 = UnitManager.SILENCE;
                }
                object4 = this.matrixPool.get(n3);
                object2 = this.getSenoneSequence((int[])object5);
                object = new SenoneHMM((Unit)object3, (SenoneSequence)object2, (float[][])object4, HMMPosition.lookup("-"));
                this.hmmManager.put((HMM)object);
            }
        } else {
            for (int i = 0; i < hTKStruct.hmmsHTK.getNhmms() && (singleHMM2 = hTKStruct.hmmsHTK.getHMM(i)) != null; ++i) {
                object7 = singleHMM2.getBaseName();
                if (this.contextIndependentUnits.containsKey(object7)) continue;
                object6 = ((String)object7).equals(SILENCE_CIPHONE) || ((String)object7).equals("SP") || ((String)object7).equals("BB") || ((String)object7).equals("XX") || ((String)object7).equals("HH") ? FILLER : "nofiller";
                n3 = singleHMM2.trIdx;
                n2 = singleHMM2.getNstates();
                object5 = new int[singleHMM2.getNbEmittingStates()];
                n = 0;
                for (int j = 0; j < n2; ++j) {
                    if (!singleHMM2.isEmitting(j)) continue;
                    object4 = singleHMM2.getState(j);
                    object5[n] = hTKStruct.hmmsHTK.getStateIdx((HMMState)object4);
                    ++n;
                }
                object3 = this.unitManager.getUnit((String)object7, object6.equals(FILLER));
                this.contextIndependentUnits.put(((Unit)object3).getName(), (Unit)object3);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Loaded " + object3);
                }
                if (((Unit)object3).isFiller() && ((Unit)object3).getName().equals(SILENCE_CIPHONE)) {
                    object3 = UnitManager.SILENCE;
                }
                object4 = this.matrixPool.get(n3);
                object2 = this.getSenoneSequence((int[])object5);
                object = new SenoneHMM((Unit)object3, (SenoneSequence)object2, (float[][])object4, HMMPosition.lookup("-"));
                this.hmmManager.put((HMM)object);
            }
        }
        object8 = "";
        singleHMM2 = null;
        object7 = null;
        object6 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        object5 = hTKStruct.hmmsHTK.get3phIt();
        while (object5.hasNext() && (singleHMM = object5.next()) != null) {
            Object object9;
            Object object10;
            Unit[] unitArray;
            Object object11;
            Object object12;
            object3 = singleHMM.getBaseName();
            object4 = singleHMM.getLeft();
            object2 = singleHMM.getRight();
            if (((String)object4).equals("-")) {
                object4 = SILENCE_CIPHONE;
            }
            if (((String)object2).equals("-")) {
                object2 = SILENCE_CIPHONE;
            }
            if (arrayList.contains(object = (String)object4 + ' ' + (String)object3 + ' ' + (String)object2)) continue;
            arrayList.add((String)object);
            object = "i";
            int n4 = singleHMM.trIdx;
            n2 = singleHMM.getNstates();
            int[] nArray = new int[singleHMM.getNbEmittingStates()];
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                if (!singleHMM.isEmitting(i)) continue;
                object12 = singleHMM.getState(i);
                nArray[n5] = hTKStruct.hmmsHTK.getStateIdx((HMMState)object12);
                ++n5;
            }
            if (!bl) continue;
            object12 = (String)object3 + ' ' + (String)object4 + ' ' + (String)object2;
            if (((String)object12).equals(object8)) {
                object11 = singleHMM2;
            } else {
                unitArray = new Unit[]{this.contextIndependentUnits.get(object4)};
                object10 = new Unit[]{this.contextIndependentUnits.get(object2)};
                object9 = LeftRightContext.get(unitArray, object10);
                object11 = this.unitManager.getUnit((String)object3, false, (Context)object9);
            }
            object8 = object12;
            singleHMM2 = object11;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + object11);
            }
            unitArray = (Unit[])this.matrixPool.get(n4);
            object10 = object6;
            if (object10 == null || !this.sameSenoneSequence(nArray, (int[])object7)) {
                object10 = this.getSenoneSequence(nArray);
            }
            object6 = object10;
            object7 = nArray;
            object9 = new SenoneHMM((Unit)object11, (SenoneSequence)object10, (float[][])unitArray, HMMPosition.lookup((String)object));
            this.hmmManager.put((HMM)object9);
        }
    }

    protected boolean sameSenoneSequence(int[] nArray, int[] nArray2) {
        if (nArray.length == nArray2.length) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected SenoneSequence getSenoneSequence(int[] nArray) {
        Senone[] senoneArray = new Senone[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            senoneArray[i] = this.senonePool.get(nArray[i]);
        }
        return new SenoneSequence(senoneArray);
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public GaussianWeights getMixtureWeights() {
        return this.mixtureWeights;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return this.matrixPool;
    }

    @Override
    public float[][] getTransformMatrix() {
        return null;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("HTKLoader");
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.matrixPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        if (this.meanTransformationMatrixPool != null) {
            this.meanTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.meanTransformationVectorPool != null) {
            this.meanTransformationVectorPool.logInfo(this.logger);
        }
        if (this.varianceTransformationMatrixPool != null) {
            this.varianceTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.varianceTransformationVectorPool != null) {
            this.varianceTransformationVectorPool.logInfo(this.logger);
        }
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }

    @Override
    public void update(Transform transform, ClusteredDensityFileData clusteredDensityFileData) {
    }

    class HTKStruct {
        HMMSet hmmsHTK;

        HTKStruct() {
        }

        public void load(String string) {
            System.err.println("HTK loading...");
            this.hmmsHTK = new HMMSet();
            this.hmmsHTK.loadHTK(string);
            System.err.println("HTK loading finished");
        }

        int getNumStates() {
            return this.hmmsHTK.getNstates();
        }

        int getGMMSize() {
            GMMDiag gMMDiag = this.hmmsHTK.gmms.get(0);
            return gMMDiag.getNgauss();
        }

        int getNcoefs() {
            GMMDiag gMMDiag = this.hmmsHTK.gmms.get(0);
            return gMMDiag.getNcoefs();
        }

        int getNumHMMs() {
            return this.hmmsHTK.getNhmms();
        }

        public Pool<float[]> htkMeans(String string) {
            Pool<float[]> pool = new Pool<float[]>(string);
            int n = this.getNumStates();
            int n2 = 1;
            int n3 = this.getGMMSize();
            pool.setFeature(Pool.Feature.NUM_SENONES, n);
            pool.setFeature(Pool.Feature.NUM_STREAMS, n2);
            pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, n3);
            int n4 = this.getNcoefs();
            for (int i = 0; i < n; ++i) {
                GMMDiag gMMDiag = this.hmmsHTK.gmms.get(i);
                for (int j = 0; j < n3; ++j) {
                    int n5;
                    float[] fArray = new float[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        fArray[n5] = gMMDiag.getMean(j, n5);
                    }
                    n5 = i * n3 + j;
                    pool.put(n5, fArray);
                }
            }
            return pool;
        }

        public Pool<float[]> htkVars(String string, float f) {
            Pool<float[]> pool = new Pool<float[]>(string);
            int n = this.getNumStates();
            int n2 = 1;
            int n3 = this.getGMMSize();
            pool.setFeature(Pool.Feature.NUM_SENONES, n);
            pool.setFeature(Pool.Feature.NUM_STREAMS, n2);
            pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, n3);
            int n4 = this.getNcoefs();
            for (int i = 0; i < n; ++i) {
                GMMDiag gMMDiag = this.hmmsHTK.gmms.get(i);
                for (int j = 0; j < n3; ++j) {
                    int n5;
                    float[] fArray = new float[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        fArray[n5] = gMMDiag.getVar(j, n5);
                    }
                    Utilities.floorData(fArray, HTKLoader.this.varianceFloor);
                    n5 = i * n3 + j;
                    pool.put(n5, fArray);
                }
            }
            return pool;
        }

        public GaussianWeights htkWeights(String string, float f) {
            int n = this.getNumStates();
            int n2 = 1;
            int n3 = this.getGMMSize();
            GaussianWeights gaussianWeights = new GaussianWeights(string, n, n3, n2);
            for (int i = 0; i < n; ++i) {
                GMMDiag gMMDiag = this.hmmsHTK.gmms.get(i);
                float[] fArray = new float[n3];
                for (int j = 0; j < n3; ++j) {
                    fArray[j] = gMMDiag.getWeight(j);
                }
                Utilities.floorData(fArray, HTKLoader.this.mixtureWeightFloor);
                HTKLoader.this.logMath.linearToLog(fArray);
                gaussianWeights.put(i, 0, fArray);
            }
            return gaussianWeights;
        }

        public Pool<float[][]> htkTrans(String string) {
            Object object;
            int n;
            Pool<float[][]> pool = new Pool<float[][]>(string);
            int n2 = this.getNumHMMs();
            if (this.hmmsHTK.transitions != null) {
                for (n = 0; n < this.hmmsHTK.transitions.size(); ++n) {
                    float[][] fArray = this.hmmsHTK.transitions.get(n);
                    object = new float[fArray.length][fArray[0].length];
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        for (int j = 0; j < ((Object)object[i]).length; ++j) {
                            object[i][j] = HTKLoader.this.logMath.linearToLog(fArray[i][j]);
                        }
                    }
                    pool.put(n, (float[][])object);
                }
            }
            for (int i = 0; i < n2; ++i) {
                object = this.hmmsHTK.getHMM(i);
                if (((SingleHMM)object).trans != null) {
                    float[][] fArray = ((SingleHMM)object).trans;
                    float[][] fArray2 = new float[fArray.length][fArray[0].length];
                    for (int j = 0; j < fArray2.length; ++j) {
                        for (int k = 0; k < fArray2[j].length; ++k) {
                            fArray2[j][k] = HTKLoader.this.logMath.linearToLog(fArray[j][k]);
                        }
                    }
                    ((SingleHMM)object).trIdx = n;
                    pool.put(n++, fArray2);
                    continue;
                }
                ((SingleHMM)object).trIdx = ((SingleHMM)object).getTransIdx();
            }
            return pool;
        }
    }
}

