/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.LazyHmmManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiGmmPool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiTextParser;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.TransitionModel;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class KaldiLoader
implements Loader {
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    private String location;
    @S4String(mandatory=true)
    public static final String PROP_LOCATION = "location";
    private UnitManager unitManager;
    private Pool<Senone> senonePool;
    private HMMManager hmmManager;
    private Properties modelProperties;
    private Map<String, Unit> contextIndependentUnits;
    private float[][] transform;

    public KaldiLoader() {
    }

    public KaldiLoader(String string, UnitManager unitManager) {
        this.init(string, unitManager);
    }

    public void init(String string, UnitManager unitManager) {
        this.location = string;
        this.unitManager = unitManager;
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.init(propertySheet.getString(PROP_LOCATION), (UnitManager)propertySheet.getComponent(PROP_UNIT_MANAGER));
    }

    @Override
    public void load() throws IOException {
        String string;
        KaldiTextParser kaldiTextParser = new KaldiTextParser(this.location);
        TransitionModel transitionModel = new TransitionModel(kaldiTextParser);
        this.senonePool = new KaldiGmmPool(kaldiTextParser);
        File file = new File(this.location, "phones.txt");
        InputStream inputStream = new URL(file.getPath()).openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (null != (string = bufferedReader.readLine())) {
            String[] stringArray = string.split(" ");
            if (!Character.isLetter(stringArray[0].charAt(0))) continue;
            hashMap.put(stringArray[0], Integer.parseInt(stringArray[1]));
        }
        this.contextIndependentUnits = new HashMap<String, Unit>();
        this.hmmManager = new LazyHmmManager(kaldiTextParser, transitionModel, this.senonePool, hashMap);
        for (String string2 : hashMap.keySet()) {
            Unit unit = this.unitManager.getUnit(string2, "SIL".equals(string2));
            this.contextIndependentUnits.put(unit.getName(), unit);
            this.hmmManager.get(HMMPosition.UNDEFINED, unit);
        }
        this.loadTransform();
        this.loadProperties();
    }

    private void loadTransform() throws IOException {
        int n;
        String string;
        URL uRL = new URL(new File(this.location, "final.mat").getPath());
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int n2 = 0;
        int n3 = 0;
        while (null != (string = bufferedReader.readLine())) {
            int n4 = 0;
            String[] stringArray = string.split("\\s+");
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (string2.isEmpty() || "[".equals(string2) || "]".equals(string2)) continue;
                arrayList.add(Float.valueOf(Float.parseFloat(string2)));
                ++n4;
            }
            if (n4 > 0) {
                ++n2;
            }
            n3 = n4;
        }
        this.transform = new float[n2][n3];
        Iterator iterator = arrayList.iterator();
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                this.transform[i][n] = ((Float)iterator.next()).floatValue();
            }
        }
    }

    private void loadProperties() throws IOException {
        String string;
        File file = new File(this.location, "feat.params");
        InputStream inputStream = new URL(file.getPath()).openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.modelProperties = new Properties();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split(" ");
            this.modelProperties.put(stringArray[0], stringArray[1]);
        }
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public Properties getProperties() {
        return this.modelProperties;
    }

    @Override
    public void logInfo() {
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return null;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return null;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return null;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return null;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return null;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return null;
    }

    @Override
    public GaussianWeights getMixtureWeights() {
        return null;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return null;
    }

    @Override
    public float[][] getTransformMatrix() {
        return this.transform;
    }

    @Override
    public void update(Transform transform, ClusteredDensityFileData clusteredDensityFileData) {
    }
}

