/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.ConstantEventMap;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.EventMap;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiTextParser;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.SplitEventMap;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.TableEventMap;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.TransitionModel;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.Map;

public class LazyHmmManager
extends HMMManager {
    private final EventMap eventMap;
    private final Pool<Senone> senonePool;
    private final Map<String, Integer> symbolTable;
    private final TransitionModel transitionModel;

    public LazyHmmManager(KaldiTextParser kaldiTextParser, TransitionModel transitionModel, Pool<Senone> pool, Map<String, Integer> map) {
        this.transitionModel = transitionModel;
        this.senonePool = pool;
        this.symbolTable = map;
        kaldiTextParser.expectToken("ContextDependency");
        kaldiTextParser.getInt();
        kaldiTextParser.getInt();
        kaldiTextParser.expectToken("ToPdf");
        this.eventMap = this.parseEventMap(kaldiTextParser);
        kaldiTextParser.expectToken("EndContextDependency");
    }

    private EventMap parseEventMap(KaldiTextParser kaldiTextParser) {
        String string = kaldiTextParser.getToken();
        if ("CE".equals(string)) {
            return new ConstantEventMap(kaldiTextParser.getInt());
        }
        if ("SE".equals(string)) {
            return this.parseSplitEventMap(kaldiTextParser);
        }
        if ("TE".equals(string)) {
            return this.parseTableEventMap(kaldiTextParser);
        }
        if ("NULL".equals(string)) {
            return null;
        }
        throw new InputMismatchException(string);
    }

    private EventMap parseSplitEventMap(KaldiTextParser kaldiTextParser) {
        int n = kaldiTextParser.getInt();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object object = kaldiTextParser.getIntArray();
        int n2 = ((int[])object).length;
        for (int i = 0; i < n2; ++i) {
            Integer n3 = object[i];
            arrayList.add(n3);
        }
        kaldiTextParser.expectToken("{");
        object = this.parseEventMap(kaldiTextParser);
        EventMap eventMap = this.parseEventMap(kaldiTextParser);
        SplitEventMap splitEventMap = new SplitEventMap(n, arrayList, (EventMap)object, eventMap);
        kaldiTextParser.expectToken("}");
        return splitEventMap;
    }

    private EventMap parseTableEventMap(KaldiTextParser kaldiTextParser) {
        int n = kaldiTextParser.getInt();
        int n2 = kaldiTextParser.getInt();
        ArrayList<EventMap> arrayList = new ArrayList<EventMap>(n2);
        kaldiTextParser.expectToken("(");
        while (0 < n2--) {
            arrayList.add(this.parseEventMap(kaldiTextParser));
        }
        kaldiTextParser.expectToken(")");
        return new TableEventMap(n, arrayList);
    }

    @Override
    public HMM get(HMMPosition hMMPosition, Unit unit) {
        Object object;
        Senone[] senoneArray;
        Object object2;
        HMM hMM = super.get(hMMPosition, unit);
        if (null != hMM) {
            return hMM;
        }
        int[] nArray = new int[3];
        nArray[1] = this.symbolTable.get(unit.getName());
        if (unit.isContextDependent()) {
            object2 = (LeftRightContext)unit.getContext();
            senoneArray = ((LeftRightContext)object2).getLeftContext()[0];
            object = ((LeftRightContext)object2).getRightContext()[0];
            nArray[0] = this.symbolTable.get(senoneArray.getName());
            nArray[2] = this.symbolTable.get(((Unit)object).getName());
        } else {
            nArray[0] = this.symbolTable.get("SIL");
            nArray[2] = this.symbolTable.get("SIL");
        }
        object2 = new int[3];
        object2[0] = this.eventMap.map(0, nArray);
        object2[1] = this.eventMap.map(1, nArray);
        object2[2] = this.eventMap.map(2, nArray);
        senoneArray = new Senone[]{this.senonePool.get((int)object2[0]), this.senonePool.get((int)object2[1]), this.senonePool.get((int)object2[2])};
        object = new SenoneSequence(senoneArray);
        float[][] fArray = this.transitionModel.getTransitionMatrix(nArray[1], (int[])object2);
        hMM = new SenoneHMM(unit, (SenoneSequence)object, fArray, hMMPosition);
        this.put(hMM);
        return hMM;
    }
}

