/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.LogMath;
import java.io.Serializable;
import java.util.Arrays;

public class MixtureComponent
implements Cloneable,
Serializable {
    private float[] mean;
    protected float[] meanTransformed;
    private float[][] meanTransformationMatrix;
    private float[] meanTransformationVector;
    private float[] variance;
    protected float[] precisionTransformed;
    private float[][] varianceTransformationMatrix;
    private float[] varianceTransformationVector;
    protected float distFloor;
    private float varianceFloor;
    public static final float DEFAULT_VAR_FLOOR = 1.0E-4f;
    public static final float DEFAULT_DIST_FLOOR = 0.0f;
    protected float logPreComputedGaussianFactor;

    public MixtureComponent(float[] fArray, float[] fArray2) {
        this(fArray, null, null, fArray2, null, null, 0.0f, 1.0E-4f);
    }

    public MixtureComponent(float[] fArray, float[][] fArray2, float[] fArray3, float[] fArray4, float[][] fArray5, float[] fArray6) {
        this(fArray, fArray2, fArray3, fArray4, fArray5, fArray6, 0.0f, 1.0E-4f);
    }

    public MixtureComponent(float[] fArray, float[][] fArray2, float[] fArray3, float[] fArray4, float[][] fArray5, float[] fArray6, float f, float f2) {
        assert (fArray4.length == fArray.length);
        this.mean = fArray;
        this.meanTransformationMatrix = fArray2;
        this.meanTransformationVector = fArray3;
        this.variance = fArray4;
        this.varianceTransformationMatrix = fArray5;
        this.varianceTransformationVector = fArray6;
        assert ((double)f >= 0.0) : "distFloot seems to be already in log-domain";
        this.distFloor = LogMath.getLogMath().linearToLog(f);
        this.varianceFloor = f2;
        this.transformStats();
        this.logPreComputedGaussianFactor = this.precomputeDistance();
    }

    public float[] getMean() {
        return this.mean;
    }

    public float[] getVariance() {
        return this.variance;
    }

    public float getScore(FloatData floatData) {
        return this.getScore(floatData.getValues());
    }

    public float getScore(float[] fArray) {
        float f = this.logPreComputedGaussianFactor;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i] - this.meanTransformed[i];
            f += f2 * f2 * this.precisionTransformed[i];
        }
        f = LogMath.getLogMath().lnToLog(f);
        if (Float.isNaN(f)) {
            System.out.println("gs is Nan, converting to 0");
            f = -3.4028235E38f;
        }
        if (f < this.distFloor) {
            f = this.distFloor;
        }
        return f;
    }

    public float precomputeDistance() {
        double d = 0.0;
        for (int i = 0; i < this.variance.length; ++i) {
            d += Math.log(this.precisionTransformed[i] * -2.0f);
        }
        d = Math.log(Math.PI * 2) * (double)this.variance.length - d;
        return -((float)d) * 0.5f;
    }

    public void transformStats() {
        int n;
        int n2;
        int n3 = this.mean.length;
        if (this.meanTransformationMatrix != null) {
            this.meanTransformed = new float[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    int n4 = n2;
                    this.meanTransformed[n4] = this.meanTransformed[n4] + this.mean[n] * this.meanTransformationMatrix[n2][n];
                }
            }
        } else {
            this.meanTransformed = this.mean;
        }
        if (this.meanTransformationVector != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = n2;
                this.meanTransformed[n5] = this.meanTransformed[n5] + this.meanTransformationVector[n2];
            }
        }
        if (this.varianceTransformationMatrix != null) {
            this.precisionTransformed = new float[this.variance.length];
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    int n6 = n2;
                    this.precisionTransformed[n6] = this.precisionTransformed[n6] + this.variance[n] * this.varianceTransformationMatrix[n2][n];
                }
            }
        } else {
            this.precisionTransformed = (float[])this.variance.clone();
        }
        if (this.varianceTransformationVector != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n7 = n2;
                this.precisionTransformed[n7] = this.precisionTransformed[n7] + this.varianceTransformationVector[n2];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            float f = this.precisionTransformed[n2] < this.varianceFloor ? this.varianceFloor : this.precisionTransformed[n2];
            this.precisionTransformed[n2] = 1.0f / (-2.0f * f);
        }
    }

    public MixtureComponent clone() throws CloneNotSupportedException {
        int n;
        MixtureComponent mixtureComponent = (MixtureComponent)super.clone();
        mixtureComponent.distFloor = this.distFloor;
        mixtureComponent.varianceFloor = this.varianceFloor;
        mixtureComponent.logPreComputedGaussianFactor = this.logPreComputedGaussianFactor;
        float[] fArray = mixtureComponent.mean = this.mean != null ? (float[])this.mean.clone() : null;
        if (this.meanTransformationMatrix != null) {
            mixtureComponent.meanTransformationMatrix = (float[][])this.meanTransformationMatrix.clone();
            for (n = 0; n < this.meanTransformationMatrix.length; ++n) {
                mixtureComponent.meanTransformationMatrix[n] = (float[])this.meanTransformationMatrix[n].clone();
            }
        }
        mixtureComponent.meanTransformationVector = this.meanTransformationVector != null ? (float[])this.meanTransformationVector.clone() : null;
        mixtureComponent.meanTransformed = this.meanTransformed != null ? (float[])this.meanTransformed.clone() : null;
        float[] fArray2 = mixtureComponent.variance = this.variance != null ? (float[])this.variance.clone() : null;
        if (this.varianceTransformationMatrix != null) {
            mixtureComponent.varianceTransformationMatrix = (float[][])this.varianceTransformationMatrix.clone();
            for (n = 0; n < this.varianceTransformationMatrix.length; ++n) {
                mixtureComponent.varianceTransformationMatrix[n] = (float[])this.varianceTransformationMatrix[n].clone();
            }
        }
        mixtureComponent.varianceTransformationVector = this.varianceTransformationVector != null ? (float[])this.varianceTransformationVector.clone() : null;
        mixtureComponent.precisionTransformed = this.precisionTransformed != null ? (float[])this.precisionTransformed.clone() : null;
        return mixtureComponent;
    }

    public String toString() {
        return "mu=" + Arrays.toString(this.mean) + " cov=" + Arrays.toString(this.variance);
    }
}

